/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.wps.web.InputParameterValues;
import org.geoserver.wps.web.RasterLayerConfiguration;
import org.geoserver.wps.web.VectorLayerConfiguration;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class BoundingBoxInputPanel
extends Panel {
    private DropDownChoice typeChoice;
    PropertyModel<Object> valueModel;
    List<String> mimeTypes;

    public BoundingBoxInputPanel(String id, InputParameterValues pv, int valueIndex) {
        super(id);
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new PropertyModel((Object)pv, "values[" + valueIndex + "]"));
        this.valueModel = new PropertyModel((Object)this.getDefaultModel(), "value");
        this.mimeTypes = pv.getSupportedMime();
        this.typeChoice = new DropDownChoice("type", (IModel)new PropertyModel(this.getDefaultModelObject(), "type"), Arrays.asList(InputParameterValues.ParameterType.values()));
        this.add(new Component[]{this.typeChoice});
        this.updateEditor();
        this.typeChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                BoundingBoxInputPanel.this.updateEditor();
                target.add(new Component[]{BoundingBoxInputPanel.this});
            }
        }});
    }

    void updateEditor() {
        if (this.get("editor") != null) {
            this.remove("editor");
        }
        this.valueModel.setObject(null);
        InputParameterValues.ParameterType pt = (InputParameterValues.ParameterType)((Object)this.typeChoice.getModelObject());
        if (pt == InputParameterValues.ParameterType.TEXT) {
            Fragment f = new Fragment("editor", "text", (MarkupContainer)this);
            DropDownChoice mimeChoice = new DropDownChoice("mime", (IModel)new PropertyModel((Object)this.getDefaultModel(), "mime"), this.mimeTypes);
            f.add(new Component[]{mimeChoice});
            f.add(new Component[]{new TextArea("textarea", this.valueModel)});
            this.add(new Component[]{f});
        } else if (pt == InputParameterValues.ParameterType.VECTOR_LAYER) {
            this.valueModel.setObject((Object)new VectorLayerConfiguration());
            Fragment f = new Fragment("editor", "vectorLayer", (MarkupContainer)this);
            DropDownChoice layer = new DropDownChoice("layer", (IModel)new PropertyModel(this.valueModel, "layerName"), this.getVectorLayerNames());
            f.add(new Component[]{layer});
            this.add(new Component[]{f});
        } else if (pt == InputParameterValues.ParameterType.RASTER_LAYER) {
            this.valueModel.setObject((Object)new RasterLayerConfiguration());
            Fragment f = new Fragment("editor", "rasterLayer", (MarkupContainer)this);
            final DropDownChoice layer = new DropDownChoice("layer", (IModel)new PropertyModel(this.valueModel, "layerName"), this.getRasterLayerNames());
            f.add(new Component[]{layer});
            this.add(new Component[]{f});
            layer.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

                protected void onUpdate(AjaxRequestTarget target) {
                    String name = layer.getDefaultModelObjectAsString();
                    LayerInfo li = GeoServerApplication.get().getCatalog().getLayerByName(name);
                    ReferencedEnvelope spatialDomain = li.getResource().getNativeBoundingBox();
                    ((RasterLayerConfiguration)BoundingBoxInputPanel.this.valueModel.getObject()).setSpatialDomain(spatialDomain);
                }
            }});
        } else {
            this.error((Serializable)((Object)"Unsupported parameter type"));
        }
    }

    List<String> getVectorLayerNames() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<String> result = new ArrayList<String>();
        for (LayerInfo li : catalog.getLayers()) {
            if (!(li.getResource() instanceof FeatureTypeInfo)) continue;
            result.add(li.getResource().prefixedName());
        }
        return result;
    }

    List<String> getRasterLayerNames() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<String> result = new ArrayList<String>();
        for (LayerInfo li : catalog.getLayers()) {
            if (!(li.getResource() instanceof CoverageInfo)) continue;
            result.add(li.getResource().prefixedName());
        }
        return result;
    }
}

