/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi.provider;

import com.thoughtworks.xstream.XStream;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.web.ogcapi.provider.TestCaseInfo;
import org.geoserver.web.ogcapi.provider.TestCaseInfoImpl;
import org.geotools.util.Version;
import org.springframework.stereotype.Component;

@Component
public class TestCaseInfoXStreamLoader
extends XStreamServiceLoader<TestCaseInfo> {
    public TestCaseInfoXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "tc");
    }

    public void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        TestCaseInfoXStreamLoader.initXStreamPersister(xp);
    }

    public static void initXStreamPersister(XStreamPersister xp) {
        XStream xs = xp.getXStream();
        xs.alias("tc", TestCaseInfo.class, TestCaseInfoImpl.class);
        xs.allowTypes(new Class[]{TestCaseInfo.class});
    }

    protected TestCaseInfo createServiceFromScratch(GeoServer gs) {
        TestCaseInfoImpl testCaseInfo = new TestCaseInfoImpl();
        testCaseInfo.setName("tc");
        return testCaseInfo;
    }

    public Class<TestCaseInfo> getServiceClass() {
        return TestCaseInfo.class;
    }

    protected TestCaseInfo initialize(TestCaseInfo service) {
        super.initialize((ServiceInfo)service);
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(new Version("1.0.2"));
        }
        if (service.getTitle() == null) {
            service.setTitle("TestCaseService");
            service.setAbstract("OGCAPI-TestCase");
        }
        return service;
    }
}

