/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceLinkDescription;
import org.geoserver.web.ogcapi.provider.TestCaseInfo;
import org.geoserver.web.ogcapi.provider.TestCaseInfoImpl;
import org.geoserver.web.ogcapi.provider.TestCaseOgcApiServiceDescriptionProvider;
import org.geoserver.web.ogcapi.provider.TestCaseService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OgcApiServiceDescriptionProviderTest
extends GeoServerSystemTestSupport {
    @Test
    public void testBasic() {
        TestCaseOgcApiServiceDescriptionProvider provider = new TestCaseOgcApiServiceDescriptionProvider(this.getGeoServer());
        Assert.assertEquals((Object)"TestCaseServiceType", (Object)provider.getServiceType());
        Assert.assertEquals((Object)"OGCAPI-TestCase", (Object)provider.getServiceName());
        Assert.assertEquals((Object)"TestCase", (Object)provider.getSpecificServiceType());
        Assert.assertTrue((String)"skip service capabilities", (boolean)provider.getServiceTypes().containsAll(Arrays.asList(provider.getServiceType(), provider.getSpecificServiceType())));
        Assert.assertEquals(TestCaseInfo.class, (Object)provider.getInfoClass());
        Assert.assertEquals(TestCaseService.class, (Object)provider.getServiceClass());
    }

    @Test
    public void testURLMangler() {
        TestCaseOgcApiServiceDescriptionProvider provider = new TestCaseOgcApiServiceDescriptionProvider(this.getGeoServer());
        String link = "../ogc/features/v1";
        String mangled = provider.ogcApiCustomCapabilitiesLinkMangler(link, null, null);
        Assert.assertEquals((Object)link, (Object)mangled);
        WorkspaceInfo wsInfo = this.getCatalog().getWorkspaceByName("cite");
        mangled = provider.ogcApiCustomCapabilitiesLinkMangler(link, wsInfo, null);
        Assert.assertEquals((Object)"../cite/ogc/features/v1", (Object)mangled);
        LayerInfo layerInfo = this.getCatalog().getLayerByName("DividedRoutes");
        mangled = provider.ogcApiCustomCapabilitiesLinkMangler(link, wsInfo, (PublishedInfo)layerInfo);
        Assert.assertEquals((Object)"../cite/DividedRoutes/ogc/features/v1", (Object)mangled);
    }

    @Before
    public void before() {
        GeoServerExtensionsHelper.singleton((String)"_TestCaseInfoImpl", (Object)new TestCaseInfoImpl(), (Class[])new Class[0]);
    }

    @After
    public void after() {
        GeoServerExtensionsHelper.clear();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addService(TestCaseInfoImpl.class, null, this.getGeoServer());
    }

    @Test
    public void testProvider() {
        TestCaseOgcApiServiceDescriptionProvider provider = new TestCaseOgcApiServiceDescriptionProvider(this.getGeoServer());
        List descriptions = provider.getServices(null, null);
        Assert.assertEquals((long)1L, (long)descriptions.size());
        Assert.assertEquals((Object)"TestCaseServiceType", (Object)((ServiceDescription)descriptions.get(0)).getServiceType());
        Assert.assertTrue((((ServiceDescription)descriptions.get(0)).getDescriptionPriority() < 100.0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"OGCAPI-TestCase", (Object)((ServiceDescription)descriptions.get(0)).getDescription().toString());
    }

    @Test
    public void testLinks() {
        TestCaseOgcApiServiceDescriptionProvider provider = new TestCaseOgcApiServiceDescriptionProvider(this.getGeoServer());
        List links = provider.getServiceLinks(null, null);
        Assert.assertEquals((long)1L, (long)links.size());
        Assert.assertEquals((Object)"TestCaseServiceType", (Object)((ServiceLinkDescription)links.get(0)).getServiceType());
        Assert.assertEquals((Object)"TestCase", (Object)((ServiceLinkDescription)links.get(0)).getSpecificServiceType());
        Assert.assertEquals((Object)"OGCAPI-TestCase", (Object)((ServiceLinkDescription)links.get(0)).getProtocol());
        Assert.assertEquals((Object)"../ogc/TestCaseService/v1", (Object)((ServiceLinkDescription)links.get(0)).getLink());
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("cite");
        links = provider.getServiceLinks(ws, null);
        Assert.assertEquals((long)1L, (long)links.size());
        Assert.assertEquals((Object)"TestCaseServiceType", (Object)((ServiceLinkDescription)links.get(0)).getServiceType());
        Assert.assertEquals((Object)"TestCase", (Object)((ServiceLinkDescription)links.get(0)).getSpecificServiceType());
        Assert.assertEquals((Object)"OGCAPI-TestCase", (Object)((ServiceLinkDescription)links.get(0)).getProtocol());
        Assert.assertEquals((Object)"../cite/ogc/TestCaseService/v1", (Object)((ServiceLinkDescription)links.get(0)).getLink());
        LayerInfo layer = this.getCatalog().getLayerByName("DividedRoutes");
        links = provider.getServiceLinks(ws, (PublishedInfo)layer);
        Assert.assertEquals((long)1L, (long)links.size());
        Assert.assertEquals((Object)"TestCaseServiceType", (Object)((ServiceLinkDescription)links.get(0)).getServiceType());
        Assert.assertEquals((Object)"TestCase", (Object)((ServiceLinkDescription)links.get(0)).getSpecificServiceType());
        Assert.assertEquals((Object)"OGCAPI-TestCase", (Object)((ServiceLinkDescription)links.get(0)).getProtocol());
        Assert.assertEquals((Object)"../cite/DividedRoutes/ogc/TestCaseService/v1", (Object)((ServiceLinkDescription)links.get(0)).getLink());
    }
}

