/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.LinkInfo;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.ogcapi.AbstractLinksEditorTest;
import org.geoserver.web.ogcapi.LinkInfoEditor;
import org.junit.After;
import org.junit.Before;

public class OGCWorkspaceSettingsConfigTest
extends AbstractLinksEditorTest {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setupPage() {
        WorkspaceInfo cite = this.getCatalog().getWorkspaceByName("cite");
        GeoServer gs = this.getGeoServer();
        SettingsInfo settings = gs.getFactory().createSettings();
        settings.setWorkspace(cite);
        ArrayList<LinkInfoImpl> links = new ArrayList<LinkInfoImpl>();
        this.link = new LinkInfoImpl("enclosure", "application/zip", "http://www.geoserver.org/data/dataset.zip");
        this.link.setTitle("The cite workspace dataset");
        this.link.setService("Features");
        links.add(this.link);
        settings.getMetadata().put("ogcApiLinks", links);
        this.getGeoServer().add(settings);
        this.login();
        tester.startPage((Page)new WorkspaceEditPage(cite));
        WebMarkupContainer extensions = (WebMarkupContainer)tester.getLastRenderedPage().get("form:tabs:panel:settings:settingsContainer:otherSettings:extensions");
        extensions.visitChildren(Component.class, (component, visit) -> {
            if (component instanceof LinkInfoEditor) {
                visit.stop();
                this.EDITOR = component.getPageRelativePath();
                this.EDITOR_FT = this.EDITOR.substring(this.EDITOR.indexOf(":") + 1);
            }
        });
    }

    @After
    public void cleanUpSettings() throws Exception {
        WorkspaceInfo cite = this.getCatalog().getWorkspaceByName("cite");
        GeoServer gs = this.getGeoServer();
        SettingsInfo settings = gs.getSettings(cite);
        if (settings != null) {
            gs.remove(settings);
        }
    }

    @Override
    protected List<LinkInfo> getLinks() {
        WorkspaceInfo cite = this.getCatalog().getWorkspaceByName("cite");
        return (List)this.getGeoServer().getSettings(cite).getMetadata().get("ogcApiLinks", List.class);
    }

    @Override
    protected String getFormName() {
        return "form";
    }
}

