/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.util.List;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.LinkInfo;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLinksEditorTest
extends GeoServerWicketTestSupport {
    final String ITEM1 = ":table:listContainer:items:1";
    final String ITEM2 = ":table:listContainer:items:2";
    final String ITEM3 = ":table:listContainer:items:3";
    final String REL = ":itemProperties:2:component:text";
    final String TYPE = ":itemProperties:3:component:text";
    final String HREF = ":itemProperties:4:component:area";
    final String TITLE = ":itemProperties:5:component:area";
    final String SERVICE = ":itemProperties:6:component:service";
    final String REMOVE = ":itemProperties:7:component:link";
    protected LinkInfoImpl link;
    String EDITOR = "publishedinfo:tabs:panel:theList:0:content:linksEditor";
    String EDITOR_FT = "tabs:panel:theList:0:content:linksEditor";

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testDisplayLinks() throws Exception {
        tester.assertModelValue(this.EDITOR + ":table:listContainer:items:1:itemProperties:2:component:text", (Object)this.link.getRel());
        tester.assertModelValue(this.EDITOR + ":table:listContainer:items:1:itemProperties:3:component:text", (Object)this.link.getType());
        tester.assertModelValue(this.EDITOR + ":table:listContainer:items:1:itemProperties:4:component:area", (Object)this.link.getHref());
        tester.assertModelValue(this.EDITOR + ":table:listContainer:items:1:itemProperties:5:component:area", (Object)this.link.getTitle());
        tester.assertModelValue(this.EDITOR + ":table:listContainer:items:1:itemProperties:6:component:service", (Object)this.link.getService());
    }

    @Test
    public void testAddLink() throws Exception {
        tester.clickLink(this.EDITOR + ":addLink");
        FormTester ft = tester.newFormTester(this.getFormName());
        String rel = "describedBy";
        String type = "application/json";
        String href = "http://www.geoserver.org/lakes-schema.json";
        String title = "Lakes schema description";
        ft.setValue(this.EDITOR_FT + ":table:listContainer:items:3:itemProperties:2:component:text", rel);
        ft.setValue(this.EDITOR_FT + ":table:listContainer:items:3:itemProperties:3:component:text", type);
        ft.setValue(this.EDITOR_FT + ":table:listContainer:items:3:itemProperties:4:component:area", href);
        ft.setValue(this.EDITOR_FT + ":table:listContainer:items:3:itemProperties:5:component:area", title);
        ft.submit("apply");
        tester.assertNoErrorMessage();
        List<LinkInfo> links = this.getLinks();
        Assert.assertEquals((long)2L, (long)links.size());
        Assert.assertEquals((Object)this.link, (Object)links.get(0));
        LinkInfo created = links.get(1);
        Assert.assertEquals((Object)rel, (Object)created.getRel());
        Assert.assertEquals((Object)type, (Object)created.getType());
        Assert.assertEquals((Object)href, (Object)created.getHref());
        Assert.assertEquals((Object)title, (Object)created.getTitle());
        Assert.assertNull((Object)created.getService());
    }

    @Test
    public void testRemoveLink() throws Exception {
        tester.executeAjaxEvent(this.EDITOR + ":table:listContainer:items:1:itemProperties:7:component:link", "click");
        tester.newFormTester(this.getFormName()).submit("apply");
        tester.assertNoErrorMessage();
        List<LinkInfo> links = this.getLinks();
        Assert.assertNull(links);
    }

    protected abstract List<LinkInfo> getLinks();

    protected abstract String getFormName();
}

