/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.web;

import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

abstract class ThreeStateAjaxCheckBox
extends AjaxCheckBox {
    private State state;
    private final State initialState;

    public ThreeStateAjaxCheckBox(String id, IModel<Boolean> model) {
        super(id, model);
        this.initialState = this.state = State.valueOf((Boolean)model.getObject());
        super.internalOnModelChanged();
    }

    @Nullable
    public Boolean getModelObject() {
        return (Boolean)super.getModelObject();
    }

    public void updateModel() {
        Boolean convertedInput = (Boolean)super.getConvertedInput();
        this.state = State.UNDEFINED == this.initialState && Boolean.FALSE.equals(convertedInput) ? State.UNDEFINED : State.valueOf(convertedInput);
        this.setModelObject(this.state.value());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.state == State.TRUE) {
            tag.put("checked", (CharSequence)"checked");
        } else {
            tag.remove("checked");
        }
    }

    public static enum State {
        TRUE(true),
        FALSE(false),
        UNDEFINED(null);

        @Nullable
        private Boolean value;

        private State(Boolean nullableState) {
            this.value = nullableState;
        }

        @Nullable
        public Boolean value() {
            return this.value;
        }

        public static State valueOf(Boolean value) {
            return null == value ? UNDEFINED : (value != false ? TRUE : FALSE);
        }
    }
}

