/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import com.google.common.collect.ImmutableSet;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.wicket.spring.test.ApplicationContextMock;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.StyleQueryUtil;
import org.geoserver.wms.mapbox.MapBoxTileBuilderFactory;
import org.geoserver.wms.vector.VectorTileBuilder;
import org.geoserver.wms.vector.VectorTileBuilderFactory;
import org.geoserver.wms.vector.VectorTileMapOutputFormat;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.memory.MemoryFeatureSource;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;

public class VectorTileMapOutputFormatTest {
    private static CoordinateReferenceSystem WEB_MERCATOR;
    private static CoordinateReferenceSystem WGS84;
    private static Style defaultPointStyle;
    private static Style defaultPolygonStyle;
    private static Style scaleDependentPolygonStyle;
    private static Style labelPolygonStyle;
    private static Style attributesPolygonStyle;
    private static Style coalescePolygonStyle;
    private VectorTileMapOutputFormat outputFormat;
    private VectorTileBuilder tileBuilderMock;
    private FeatureLayer pointLayer;
    private FeatureLayer scaleDependentPolygonLayer;
    private FeatureLayer labelPolygonLayer;
    private FeatureLayer attributesPolygonLayer;
    private List<MapContent> mapContents = new ArrayList<MapContent>();
    private MemoryDataStore ds;

    @BeforeClass
    public static void beforeClass() throws Exception {
        defaultPointStyle = VectorTileMapOutputFormatTest.parseStyle("default_point.sld");
        defaultPolygonStyle = VectorTileMapOutputFormatTest.parseStyle("default_polygon.sld");
        scaleDependentPolygonStyle = VectorTileMapOutputFormatTest.parseStyle("scaleDependentPolygonStyle.sld");
        labelPolygonStyle = VectorTileMapOutputFormatTest.parseStyle("labelsPolygonStyle.sld");
        attributesPolygonStyle = VectorTileMapOutputFormatTest.parseStyle("attributesPolygonStyle.sld");
        coalescePolygonStyle = VectorTileMapOutputFormatTest.parseStyle("coalescePolygonStyle.sld");
        GeoServerExtensionsHelper.init((ApplicationContext)new ApplicationContextMock());
        WEB_MERCATOR = CRS.decode((String)"EPSG:3857");
        WGS84 = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:4326");
    }

    @Before
    public void before() throws Exception {
        this.tileBuilderMock = (VectorTileBuilder)Mockito.mock(VectorTileBuilder.class);
        VectorTileBuilderFactory tileBuilderFactory = (VectorTileBuilderFactory)Mockito.mock(VectorTileBuilderFactory.class);
        Mockito.when((Object)tileBuilderFactory.getMimeType()).thenReturn((Object)"testMime");
        Mockito.when((Object)tileBuilderFactory.getOutputFormats()).thenReturn((Object)ImmutableSet.of((Object)"testMime", (Object)"testFormat"));
        Mockito.when((Object)tileBuilderFactory.newBuilder((Rectangle)ArgumentMatchers.any(Rectangle.class), (ReferencedEnvelope)ArgumentMatchers.any(ReferencedEnvelope.class))).thenReturn((Object)this.tileBuilderMock);
        this.outputFormat = new VectorTileMapOutputFormat(tileBuilderFactory);
        this.outputFormat.setClipToMapBounds(true);
        this.ds = new MemoryDataStore();
        String pointsTypeSpec = "sp:String,ip:Integer,geom:Point:srid=4326";
        String linesTypeSpec = "sp:String,ip:Integer,geom:LineString:srid=4326";
        String polyTypeSpec = "sp:String,ip:Integer,geom:Polygon:srid=4326";
        SimpleFeatureType pointType = DataUtilities.createType((String)"points", (String)"sp:String,ip:Integer,geom:Point:srid=4326");
        SimpleFeatureType lineType = DataUtilities.createType((String)"lines", (String)"sp:String,ip:Integer,geom:LineString:srid=4326");
        SimpleFeatureType polyType = DataUtilities.createType((String)"polygons", (String)"sp:String,ip:Integer,geom:Polygon:srid=4326");
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(pointType, "point1", "StringProp1_1", 1000, "POINT(1 1)"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(pointType, "point2", "StringProp1_2", 2000, "POINT(2 2)"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(pointType, "point3", "StringProp1_3", 3000, "POINT(3 3)"));
        double bufferBoundary = -22.5;
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(pointType, "pointNear", "StringProp1_4", 3000, String.format("POINT(3 %s)", bufferBoundary + 0.1)));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(pointType, "pointFar", "StringProp1_5", 3000, String.format("POINT(3 %s)", bufferBoundary - 1.0)));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(lineType, "line1", "StringProp2_1", 1000, "LINESTRING (1 1, 2 2)"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(lineType, "line1", "StringProp2_2", 2000, "LINESTRING (3 3, 4 4)"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(lineType, "line1", "StringProp2_3", 3000, "LINESTRING (5 5, 6 6)"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(polyType, "polygon1", "StringProp3_1", 1000, "POLYGON ((1 0, 2 0, 2 1, 1 1, 1 0))"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(polyType, "polygon2", "StringProp3_2", 2000, "POLYGON ((6 6, 7 6, 7 7, 6 7, 6 6))"));
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(polyType, "polygon3", "StringProp3_3", 3000, "POLYGON ((11 11, 12 11, 12 12, 11 12, 11 11))"));
        this.pointLayer = new FeatureLayer((FeatureSource)this.ds.getFeatureSource("points"), defaultPointStyle);
        this.scaleDependentPolygonLayer = new FeatureLayer((FeatureSource)this.ds.getFeatureSource("polygons"), scaleDependentPolygonStyle);
        this.labelPolygonLayer = new FeatureLayer((FeatureSource)this.ds.getFeatureSource("polygons"), labelPolygonStyle);
        this.attributesPolygonLayer = new FeatureLayer((FeatureSource)this.ds.getFeatureSource("polygons"), attributesPolygonStyle);
    }

    @After
    public void disposeMapContents() {
        this.mapContents.forEach(mc -> mc.dispose());
    }

    @Test
    public void testNoRulesByScale() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(0.0, 0.005, 0.0, 0.005, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 0, new Layer[]{this.scaleDependentPolygonLayer});
        Query q = StyleQueryUtil.getStyleQuery((Layer)this.scaleDependentPolygonLayer, (WMSMapContent)mapContent);
        Assert.assertNotSame((Object)q.getFilter(), (Object)Filter.EXCLUDE);
        mapBounds = new ReferencedEnvelope(0.0, 0.05, 0.0, 0.05, WGS84);
        renderingArea = new Rectangle(256, 256);
        mapContent = this.createMapContent(mapBounds, renderingArea, 0, new Layer[]{this.scaleDependentPolygonLayer});
        q = StyleQueryUtil.getStyleQuery((Layer)this.scaleDependentPolygonLayer, (WMSMapContent)mapContent);
        Assert.assertSame((Object)q.getFilter(), (Object)Filter.EXCLUDE);
    }

    @Test
    public void testBufferOversample() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(-90.0, 90.0, 0.0, 180.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 32, new Layer[]{this.pointLayer});
        MapBoxTileBuilderFactory mbbf = new MapBoxTileBuilderFactory();
        VectorTileMapOutputFormat vtof = new VectorTileMapOutputFormat((VectorTileBuilderFactory)mbbf);
        VectorTileMapOutputFormat vtof_spy = (VectorTileMapOutputFormat)Mockito.spy((Object)vtof);
        int expectedBuffer = 32 * mbbf.getOversampleX();
        vtof_spy.produceMap(mapContent);
        ((VectorTileMapOutputFormat)Mockito.verify((Object)vtof_spy)).getPipeline((WMSMapContent)ArgumentMatchers.any(WMSMapContent.class), (ReferencedEnvelope)ArgumentMatchers.any(ReferencedEnvelope.class), (Rectangle)ArgumentMatchers.any(Rectangle.class), (CoordinateReferenceSystem)ArgumentMatchers.any(CoordinateReferenceSystem.class), VectorTileMapOutputFormatTest.anyKeySet(), (Hints)ArgumentMatchers.any(Hints.class), ArgumentMatchers.eq((int)expectedBuffer));
    }

    private static Set<RenderingHints.Key> anyKeySet() {
        return (Set)ArgumentMatchers.any(Set.class);
    }

    @Test
    public void testBuffer() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(-90.0, 90.0, 0.0, 180.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 32, new Layer[]{this.pointLayer});
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point1"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point2"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointFar"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointNear"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
    }

    private static Map<String, Object> anyProperties() {
        return (Map)ArgumentMatchers.any(Map.class);
    }

    @Test
    public void testBufferProject() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(0.0, 2.003750834E7, 0.0, 2.003750834E7, WEB_MERCATOR);
        Rectangle renderingArea = new Rectangle(256, 256);
        ReferencedEnvelope qbounds = new ReferencedEnvelope(mapBounds);
        qbounds.expandBy(2504688.5425);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 32, new Layer[]{this.pointLayer});
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point1"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point2"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointFar"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointNear"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
    }

    @Test
    public void testSimple() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(-90.0, 90.0, 0.0, 180.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, null, new Layer[]{this.pointLayer});
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point1"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point2"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointFar"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointNear"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
    }

    @Test
    public void testCQLfilter() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(-90.0, 90.0, 0.0, 180.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, null, new Layer[]{this.pointLayer});
        FeatureLayer layer = (FeatureLayer)mapContent.layers().get(0);
        layer.setQuery(new Query(null, ECQL.toFilter((String)"sp = 'StringProp1_2'")));
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point1"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point2"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"point3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointFar"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.never())).addFeature((String)ArgumentMatchers.eq((Object)"points"), (String)ArgumentMatchers.eq((Object)"pointNear"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Geometry.class), VectorTileMapOutputFormatTest.anyProperties());
    }

    private WMSMapContent createMapContent(ReferencedEnvelope mapBounds, Rectangle renderingArea, Integer buffer, Layer ... layers) throws Exception {
        GetMapRequest mapRequest = this.createGetMapRequest(mapBounds, renderingArea, buffer);
        WMSMapContent map = new WMSMapContent(mapRequest);
        map.getViewport().setBounds(mapBounds);
        if (layers != null) {
            for (Layer l : layers) {
                map.addLayer(l);
            }
        }
        map.setMapWidth(renderingArea.width);
        map.setMapHeight(renderingArea.height);
        if (Objects.nonNull(buffer)) {
            map.setBuffer(buffer.intValue());
        }
        this.mapContents.add((MapContent)map);
        return map;
    }

    protected GetMapRequest createGetMapRequest(ReferencedEnvelope requestEnvelope, Rectangle renderingArea, Integer buffer) {
        GetMapRequest request = new GetMapRequest();
        request.setBaseUrl("http://localhost:8080/geoserver");
        ArrayList layers = new ArrayList();
        ArrayList styles = new ArrayList();
        request.setLayers(layers);
        request.setStyles(styles);
        request.setBbox((Envelope)requestEnvelope);
        request.setCrs(requestEnvelope.getCoordinateReferenceSystem());
        if (requestEnvelope.getCoordinateReferenceSystem() == WGS84) {
            request.setSRS("EPSG:4326");
        } else if (requestEnvelope.getCoordinateReferenceSystem() == WEB_MERCATOR) {
            request.setSRS("EPSG:3857");
        } else {
            throw new IllegalArgumentException("Please use one of the test CRS's");
        }
        request.setWidth(renderingArea.width);
        request.setHeight(renderingArea.height);
        request.setRawKvp(new HashMap());
        request.setBuffer(buffer);
        return request;
    }

    @Test
    public void testPregeneralized() throws Exception {
        String polyTypeSpec = "sp:String,ip:Integer,geom:Polygon:srid=4326";
        SimpleFeatureType pregenPolyType = DataUtilities.createType((String)"pregenPolygon", (String)"sp:String,ip:Integer,geom:Polygon:srid=4326");
        final class PregenDataStore
        extends MemoryDataStore {
            protected ContentFeatureSource createFeatureSource(ContentEntry entry, Query query) {
                return new 1PregenDataStore._FeatureSource(entry, query);
            }

            final class 1PregenDataStore._FeatureSource
            extends MemoryFeatureSource {
                public 1PregenDataStore._FeatureSource(ContentEntry entry, Query q) {
                    super(entry, q);
                }

                protected void addHints(Set<Hints.Key> hints) {
                    hints.add(Hints.GEOMETRY_DISTANCE);
                }
            }
        }
        PregenDataStore _ds = new PregenDataStore();
        _ds.addFeature(VectorTileMapOutputFormatTest.feature(pregenPolyType, "pregenPolygon1", "StringPropX_1", 1000, "POLYGON ((1 1, 2 2, 3 3, 4 4, 1 1))"));
        ContentFeatureSource fs = _ds.getFeatureSource("pregenPolygon");
        FeatureLayer pregeneralizedLayer = new FeatureLayer((FeatureSource)fs, defaultPolygonStyle);
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(-90.0, 90.0, 0.0, 180.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 0, new Layer[]{pregeneralizedLayer});
        Assert.assertTrue((boolean)pregeneralizedLayer.getSimpleFeatureSource().getSupportedHints().contains(Hints.GEOMETRY_DISTANCE));
        MapBoxTileBuilderFactory mbbf = new MapBoxTileBuilderFactory();
        VectorTileMapOutputFormat vtof = new VectorTileMapOutputFormat((VectorTileBuilderFactory)mbbf);
        VectorTileMapOutputFormat vtof_spy = (VectorTileMapOutputFormat)Mockito.spy((Object)vtof);
        vtof_spy.produceMap(mapContent);
        ((VectorTileMapOutputFormat)Mockito.verify((Object)vtof_spy)).getPipeline((WMSMapContent)ArgumentMatchers.any(WMSMapContent.class), (ReferencedEnvelope)ArgumentMatchers.any(ReferencedEnvelope.class), (Rectangle)ArgumentMatchers.any(Rectangle.class), (CoordinateReferenceSystem)ArgumentMatchers.any(CoordinateReferenceSystem.class), VectorTileMapOutputFormatTest.anyKeySet(), (Hints)ArgumentMatchers.argThat(qH -> qH.containsKey((Object)Hints.GEOMETRY_DISTANCE)), ((Integer)ArgumentMatchers.any(Integer.class)).intValue());
    }

    public static SimpleFeature feature(SimpleFeatureType type, String id, Object ... values) throws ParseException {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (type.getDescriptor(i) instanceof GeometryDescriptor && value instanceof String) {
                value = VectorTileMapOutputFormatTest.parseGeometry((String)value);
            }
            builder.set(i, value);
        }
        return builder.buildFeature(id);
    }

    private static Geometry parseGeometry(String value) throws ParseException {
        return new WKTReader2().read(value);
    }

    private static Style parseStyle(String styleResource) throws IOException {
        try (InputStream in = GeoServerLoader.class.getResourceAsStream(styleResource);){
            StyledLayerDescriptor sld = new SLDHandler().parse((Object)in, null, null, null);
            Style style = ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0];
            return style;
        }
    }

    @Test
    public void testLabelPoints() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(0.0, 15.0, 0.0, 15.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 0, new Layer[]{this.labelPolygonLayer});
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons_labels"), (String)ArgumentMatchers.eq((Object)"polygon1"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.eq((Object)VectorTileMapOutputFormatTest.parseGeometry("POINT (1.5 0.5)")), (Map)ArgumentMatchers.eq(Map.of("sp", "StringProp3_1")));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons_labels"), (String)ArgumentMatchers.eq((Object)"polygon2"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.eq((Object)VectorTileMapOutputFormatTest.parseGeometry("POINT (6.5 6.5)")), (Map)ArgumentMatchers.eq(Map.of("sp", "StringProp3_2")));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons_labels"), (String)ArgumentMatchers.eq((Object)"polygon3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.eq((Object)VectorTileMapOutputFormatTest.parseGeometry("POINT (11.5 11.5)")), (Map)ArgumentMatchers.eq(Map.of("sp", "StringProp3_3")));
    }

    @Test
    public void testAttributeSelection() throws Exception {
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(0.0, 15.0, 0.0, 15.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 0, new Layer[]{this.attributesPolygonLayer});
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons"), (String)ArgumentMatchers.eq((Object)"polygon1"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Polygon.class), (Map)ArgumentMatchers.eq(Map.of("ip", 1000)));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons"), (String)ArgumentMatchers.eq((Object)"polygon2"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Polygon.class), (Map)ArgumentMatchers.eq(Map.of("ip", 2000)));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons"), (String)ArgumentMatchers.eq((Object)"polygon3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(Polygon.class), (Map)ArgumentMatchers.eq(Map.of("ip", 3000)));
    }

    @Test
    public void testCoalesce() throws Exception {
        this.ds.addFeature(VectorTileMapOutputFormatTest.feature(this.ds.getSchema("polygons"), "polygon4", "StringProp3_3", 3000, "POLYGON ((15 15, 16 15, 16 16, 15 16, 15 15))"));
        FeatureLayer coalescePolygonLayer = new FeatureLayer((FeatureSource)this.ds.getFeatureSource("polygons"), coalescePolygonStyle);
        coalescePolygonLayer.setQuery(new Query("polygons", ECQL.toFilter((String)"sp = 'StringProp3_3'")));
        ReferencedEnvelope mapBounds = new ReferencedEnvelope(0.0, 15.0, 0.0, 15.0, WGS84);
        Rectangle renderingArea = new Rectangle(256, 256);
        WMSMapContent mapContent = this.createMapContent(mapBounds, renderingArea, 0, new Layer[]{coalescePolygonLayer});
        WebMap mockMap = (WebMap)Mockito.mock(WebMap.class);
        Mockito.when((Object)this.tileBuilderMock.build((WMSMapContent)ArgumentMatchers.same((Object)mapContent))).thenReturn((Object)mockMap);
        Assert.assertSame((Object)mockMap, (Object)this.outputFormat.produceMap(mapContent));
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Geometry)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((VectorTileBuilder)Mockito.verify((Object)this.tileBuilderMock, (VerificationMode)Mockito.times((int)1))).addFeature((String)ArgumentMatchers.eq((Object)"polygons"), (String)ArgumentMatchers.eq((Object)"polygon3"), (String)ArgumentMatchers.eq((Object)"geom"), (Geometry)ArgumentMatchers.any(MultiPolygon.class), (Map)ArgumentMatchers.eq(Map.of("sp", "StringProp3_3", "ip", 3000)));
    }
}

