/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import java.util.HashMap;
import no.ecc.vectortile.VectorTileEncoderNoClip;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class VectorTileEncoderNoClipTest {
    @Test
    public void testNoClippingApplied() {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        VectorTileEncoderNoClip encoder = new VectorTileEncoderNoClip(4096, 100, false);
        LineString lineOutsideBounds = geometryFactory.createLineString(new Coordinate[]{new Coordinate(-150.0, 0.0), new Coordinate(-150.0, 150.0)});
        encoder.addFeature("ClipTestLayer", new HashMap(), (Geometry)lineOutsideBounds);
        byte[] tile = encoder.encode();
        Assert.assertTrue((String)"Line should not be clipped", (tile.length > 0 ? 1 : 0) != 0);
        encoder = new VectorTileEncoderNoClip(4096, 100, false);
        Point pointOutsideBounds = geometryFactory.createPoint(new Coordinate(-150.0, 0.0));
        encoder.addFeature("ClipTestLayer", new HashMap(), (Geometry)pointOutsideBounds);
        tile = encoder.encode();
        Assert.assertTrue((String)"Point should not be clipped", (tile.length > 0 ? 1 : 0) != 0);
    }
}

