/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.topojson;

import com.google.common.collect.ImmutableList;
import java.awt.geom.AffineTransform;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.geoserver.wms.topojson.TopoGeom;
import org.geoserver.wms.topojson.TopoJSONEncoder;
import org.geoserver.wms.topojson.Topology;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class TopoJSONEncoderTest {
    @Test
    public void testIdentity() throws Exception {
        TopoJSONEncoder encoder = new TopoJSONEncoder();
        AffineTransform identity = new AffineTransform();
        List<LineString> arcs = this.arcs("LINESTRING(0 1, 2 3)");
        ImmutableList geoms = ImmutableList.of((Object)new TopoGeom.LineString((List)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5)));
        TopoGeom.GeometryColleciton layer = new TopoGeom.GeometryColleciton((Collection)geoms);
        HashMap<String, TopoGeom.GeometryColleciton> layers = new HashMap<String, TopoGeom.GeometryColleciton>();
        layers.put("topp:states", layer);
        Topology topology = new Topology(identity, arcs, layers);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)NullOutputStream.INSTANCE);){
            encoder.encode(topology, (Writer)writer);
        }
    }

    @Test
    public void testQuantization() throws Exception {
        TopoJSONEncoder encoder = new TopoJSONEncoder();
        double translateX = 100.0;
        double translateY = 200.0;
        double scaleX = 0.001;
        double scaleY = 0.01;
        AffineTransform tx = new AffineTransform();
        tx.translate(100.0, 200.0);
        tx.scale(0.001, 0.01);
        List<LineString> arcs = this.arcs("LINESTRING(0 1, 2 3)");
        ImmutableList geoms = ImmutableList.of((Object)new TopoGeom.LineString((List)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5)));
        TopoGeom.GeometryColleciton layer = new TopoGeom.GeometryColleciton((Collection)geoms);
        HashMap<String, TopoGeom.GeometryColleciton> layers = new HashMap<String, TopoGeom.GeometryColleciton>();
        layers.put("topp:states", layer);
        Topology topology = new Topology(tx, arcs, layers);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)NullOutputStream.INSTANCE);){
            encoder.encode(topology, (Writer)writer);
        }
    }

    private List<LineString> arcs(String ... WKT) throws ParseException {
        ArrayList<LineString> arcs = new ArrayList<LineString>();
        WKTReader reader = new WKTReader();
        for (String wktString : WKT) {
            LineString l = (LineString)reader.read(wktString);
            arcs.add(l);
        }
        return arcs;
    }
}

