/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.web;

import java.io.Serializable;
import java.util.UUID;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParameterBuilder;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleBuilder;

public class RuleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Integer position;
    private String match;
    private String activation;
    private String parameter;
    private String transform;
    private Integer remove;
    private String combine;
    private Boolean repeat;
    private boolean activated;
    private boolean echo;
    private boolean isForwardOnly;

    public RuleModel() {
        this(false);
    }

    public RuleModel(boolean isForwardOnly) {
        this.id = UUID.randomUUID().toString();
        this.activated = true;
        this.isForwardOnly = isForwardOnly;
    }

    public RuleModel(Rule rule) {
        this.id = rule.getId();
        this.activated = rule.getActivated();
        this.position = rule.getPosition();
        this.match = rule.getMatch();
        this.activation = rule.getActivation();
        this.parameter = rule.getParameter();
        this.transform = rule.getTransform();
        this.remove = rule.getRemove();
        this.combine = rule.getCombine();
        this.repeat = rule.getRepeat();
        if (this.position != null && this.transform != null) {
            this.transform = this.transform.replace("$2", "{PARAMETER}");
        }
    }

    public RuleModel(EchoParameter echoParameter) {
        this.id = echoParameter.getId();
        this.parameter = echoParameter.getParameter();
        this.activated = echoParameter.getActivated();
        this.echo = true;
        this.isForwardOnly = true;
    }

    public Rule toRule() {
        RuleBuilder ruleBuilder = new RuleBuilder().withId(this.id).withActivated(this.activated).withPosition(this.position).withMatch(this.match).withActivation(this.activation).withParameter(this.parameter).withRemove(this.remove).withCombine(this.combine).withRepeat(this.repeat);
        if (this.position != null && this.transform != null) {
            ruleBuilder.withTransform(this.transform.replace("{PARAMETER}", "$2"));
        } else {
            ruleBuilder.withTransform(this.transform);
        }
        return ruleBuilder.build();
    }

    public EchoParameter toEchoParameter() {
        return new EchoParameterBuilder().withId(this.id).withParameter(this.parameter).withActivated(this.activated).build();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public String getActivation() {
        return this.activation;
    }

    public void setActivation(String activation) {
        this.activation = activation;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    public Integer getRemove() {
        return this.remove;
    }

    public void setRemove(Integer remove) {
        this.remove = remove;
    }

    public String getCombine() {
        return this.combine;
    }

    public void setCombine(String combine) {
        this.combine = combine;
    }

    public Boolean getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public boolean getEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public boolean isEchoOnly() {
        return this.isForwardOnly;
    }
}

