/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParametersDaoTest;
import org.geoserver.params.extractor.Rule;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.util.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public abstract class TestSupport {
    private static final File TEST_DIRECTORY = new File(System.getProperty("java.io.tmpdir"), "params-extractor-data-directory");
    protected static final ApplicationContext APPLICATION_CONTEXT = new FileSystemXmlApplicationContext("file:" + TestSupport.class.getClassLoader().getResource("testApplicationContext.xml").getFile());
    protected ResourceStore resourceStore;

    @Before
    public void voidSetup() {
        this.deleteTestDirectoryQuietly();
        TEST_DIRECTORY.mkdir();
        this.resourceStore = new FileSystemResourceStore(TEST_DIRECTORY);
    }

    @After
    public void voidClean() throws IOException {
        this.deleteTestDirectoryQuietly();
    }

    private void deleteTestDirectoryQuietly() {
        try {
            IOUtils.delete((File)TEST_DIRECTORY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Resource getResource(String resourcePath) {
        URL resource = EchoParametersDaoTest.class.getClassLoader().getResource(resourcePath);
        MatcherAssert.assertThat((Object)resource, (Matcher)CoreMatchers.notNullValue());
        File file = new File(resource.getFile());
        MatcherAssert.assertThat((Object)file.exists(), (Matcher)CoreMatchers.is((Object)true));
        return Files.asResource((File)file);
    }

    protected void checkRule(Rule ruleA, Rule ruleB) {
        MatcherAssert.assertThat((Object)ruleA, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)ruleB, (Matcher)CoreMatchers.notNullValue());
        this.checkValue(ruleA, ruleB, Rule::getId);
        this.checkValue(ruleA, ruleB, Rule::getActivated);
        this.checkValue(ruleA, ruleB, Rule::getPosition);
        this.checkValue(ruleA, ruleB, Rule::getMatch);
        this.checkValue(ruleA, ruleB, Rule::getParameter);
        this.checkValue(ruleA, ruleB, Rule::getActivation);
        this.checkValue(ruleA, ruleB, Rule::getTransform);
        this.checkValue(ruleA, ruleB, Rule::getRemove);
        this.checkValue(ruleA, ruleB, Rule::getCombine);
    }

    protected void checkEchoParameter(EchoParameter echoParameterA, EchoParameter echoParameterB) {
        MatcherAssert.assertThat((Object)echoParameterA, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)echoParameterB, (Matcher)CoreMatchers.notNullValue());
        this.checkValue(echoParameterA, echoParameterB, EchoParameter::getId);
        this.checkValue(echoParameterA, echoParameterB, EchoParameter::getActivated);
        this.checkValue(echoParameterA, echoParameterB, EchoParameter::getParameter);
    }

    protected <T, R> void checkValue(T objectA, T objectB, Function<T, R> getter) {
        R valueA = getter.apply(objectA);
        R valueB = getter.apply(objectB);
        if (valueA == null) {
            MatcherAssert.assertThat(valueB, (Matcher)CoreMatchers.nullValue());
        } else {
            MatcherAssert.assertThat(valueB, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat(valueA, (Matcher)CoreMatchers.is(valueB));
        }
    }

    protected EchoParameter findEchoParameter(String id, List<EchoParameter> echoParameters) {
        return echoParameters.stream().filter(echoParameter -> echoParameter.getId().equals(id)).findFirst().orElse(null);
    }

    protected Rule findRule(String id, List<Rule> rules) {
        return rules.stream().filter(rule -> rule.getId().equals(id)).findFirst().orElse(null);
    }
}

