/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.List;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParameterBuilder;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleBuilder;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.TestSupport;
import org.geoserver.params.extractor.web.RuleModel;
import org.geoserver.params.extractor.web.RulesModel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public final class RulesModelTest
extends TestSupport {
    @Test
    public void testCrudRuleModel() throws Exception {
        Rule ruleA = new RuleBuilder().withId("0").withActivated(Boolean.valueOf(true)).withPosition(Integer.valueOf(3)).withParameter("cql_filter").withTransform("CFCC='$2'").build();
        Rule ruleB = new RuleBuilder().withId("0").withActivated(Boolean.valueOf(false)).withPosition(Integer.valueOf(2)).withParameter("cql_filter").withTransform("CFCC='$2'").build();
        EchoParameter echoParameterA = new EchoParameterBuilder().withId("0").withParameter("cql_filter").withActivated(Boolean.valueOf(false)).build();
        EchoParameter echoParameterB = new EchoParameterBuilder().withId("0").withParameter("cql_filter").withActivated(Boolean.valueOf(false)).build();
        RuleModel ruleModelA = new RuleModel(ruleA);
        this.checkRule(ruleA, ruleModelA.toRule());
        RulesModel.saveOrUpdate((RuleModel)ruleModelA);
        List rulesModels = RulesModel.getRulesModels();
        MatcherAssert.assertThat((Object)rulesModels.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleA, ((RuleModel)rulesModels.get(0)).toRule());
        List rules = RulesDao.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleA, (Rule)rules.get(0));
        RuleModel ruleModelB = new RuleModel(ruleB);
        ruleModelB.setEcho(true);
        this.checkRule(ruleB, ruleModelB.toRule());
        this.checkEchoParameter(echoParameterA, ruleModelB.toEchoParameter());
        RulesModel.saveOrUpdate((RuleModel)ruleModelB);
        rulesModels = RulesModel.getRulesModels();
        MatcherAssert.assertThat((Object)rulesModels.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleB, ((RuleModel)rulesModels.get(0)).toRule());
        this.checkEchoParameter(echoParameterA, ((RuleModel)rulesModels.get(0)).toEchoParameter());
        rules = RulesDao.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleB, (Rule)rules.get(0));
        List echoParameters = EchoParametersDao.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkEchoParameter(echoParameterA, (EchoParameter)echoParameters.get(0));
        ruleModelB.setEcho(false);
        RulesModel.saveOrUpdate((RuleModel)ruleModelB);
        rulesModels = RulesModel.getRulesModels();
        MatcherAssert.assertThat((Object)rulesModels.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleB, ((RuleModel)rulesModels.get(0)).toRule());
        MatcherAssert.assertThat((Object)((RuleModel)rulesModels.get(0)).getEcho(), (Matcher)CoreMatchers.is((Object)false));
        rules = RulesDao.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleB, (Rule)rules.get(0));
        echoParameters = EchoParametersDao.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)0));
        EchoParametersDao.saveOrUpdateEchoParameter((EchoParameter)echoParameterB);
        rulesModels = RulesModel.getRulesModels();
        MatcherAssert.assertThat((Object)rulesModels.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleB, ((RuleModel)rulesModels.get(0)).toRule());
        this.checkEchoParameter(echoParameterB, ((RuleModel)rulesModels.get(0)).toEchoParameter());
        rules = RulesDao.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        echoParameters = EchoParametersDao.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)1));
        RulesModel.delete((String[])new String[]{"0"});
        rulesModels = RulesModel.getRulesModels();
        MatcherAssert.assertThat((Object)rulesModels.size(), (Matcher)CoreMatchers.is((Object)0));
        rules = RulesDao.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)0));
        echoParameters = EchoParametersDao.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

