/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.List;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParameterBuilder;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.params.extractor.TestSupport;
import org.geoserver.platform.resource.Resource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public final class EchoParametersDaoTest
extends TestSupport {
    static List<EchoParameter> getEchoParameters() {
        return EchoParametersDao.getEchoParameters();
    }

    static List<EchoParameter> getEchoParameters(String path) {
        return EchoParametersDao.getEchoParameters((Resource)EchoParametersDaoTest.getResource(path));
    }

    @Test
    public void testParsingEmptyFile() {
        List<EchoParameter> echoParameters = EchoParametersDaoTest.getEchoParameters("data/echoParameters1.xml");
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testParsingEmptyEchoParameters() {
        List<EchoParameter> echoParameters = EchoParametersDaoTest.getEchoParameters("data/echoParameters2.xml");
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testParsingEchoParameter() {
        List<EchoParameter> echoParameters = EchoParametersDaoTest.getEchoParameters("data/echoParameters3.xml");
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkEchoParameter(echoParameters.get(0), new EchoParameterBuilder().withId("1").withParameter("CQL_FILTER").withActivated(Boolean.valueOf(true)).build());
    }

    @Test
    public void testParsingMultipleEchoParameters() {
        List<EchoParameter> echoParameters = EchoParametersDaoTest.getEchoParameters("data/echoParameters4.xml");
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)2));
        this.checkEchoParameter(this.findEchoParameter("0", echoParameters), new EchoParameterBuilder().withId("0").withParameter("CQL_FILTER").withActivated(Boolean.valueOf(true)).build());
        this.checkEchoParameter(this.findEchoParameter("1", echoParameters), new EchoParameterBuilder().withId("1").withParameter("BBOX").withActivated(Boolean.valueOf(false)).build());
    }

    @Test
    public void testEchoParameterCrud() {
        EchoParameter echoParameterA = new EchoParameterBuilder().withId("0").withActivated(Boolean.valueOf(true)).withParameter("cql_filter").build();
        EchoParameter echoParameterB = new EchoParameterBuilder().withId("1").withActivated(Boolean.valueOf(true)).withParameter("bbox").build();
        EchoParameter echoParameterC = new EchoParameterBuilder().withId("1").withActivated(Boolean.valueOf(false)).withParameter("bbox").build();
        List<EchoParameter> echoParameters = EchoParametersDaoTest.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)0));
        EchoParametersDao.saveOrUpdateEchoParameter((EchoParameter)echoParameterA);
        EchoParametersDao.saveOrUpdateEchoParameter((EchoParameter)echoParameterB);
        echoParameters = EchoParametersDaoTest.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)2));
        this.checkEchoParameter(echoParameterA, this.findEchoParameter("0", echoParameters));
        this.checkEchoParameter(echoParameterB, this.findEchoParameter("1", echoParameters));
        EchoParametersDao.saveOrUpdateEchoParameter((EchoParameter)echoParameterC);
        echoParameters = EchoParametersDaoTest.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)2));
        this.checkEchoParameter(echoParameterA, this.findEchoParameter("0", echoParameters));
        this.checkEchoParameter(echoParameterC, this.findEchoParameter("1", echoParameters));
        EchoParametersDao.deleteEchoParameters((String[])new String[]{"0"});
        echoParameters = EchoParametersDaoTest.getEchoParameters();
        MatcherAssert.assertThat((Object)echoParameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

