/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.web;

import java.util.Optional;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentUpdatingBehavior;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.params.extractor.UrlTransform;
import org.geoserver.params.extractor.Utils;
import org.geoserver.params.extractor.web.ParamsExtractorRulePage;
import org.geoserver.params.extractor.web.RuleModel;
import org.geoserver.params.extractor.web.RuleTestModel;
import org.geoserver.params.extractor.web.RulesModel;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;

public class ParamsExtractorConfigPage
extends GeoServerSecuredPage {
    GeoServerTablePanel<RuleModel> rulesPanel;

    public ParamsExtractorConfigPage() {
        this.setHeaderPanel(this.headerPanel());
        Component[] componentArray = new Component[1];
        this.rulesPanel = new GeoServerTablePanel<RuleModel>("rulesPanel", (GeoServerDataProvider)new RulesModel(), true){

            protected Component getComponentForProperty(String id, IModel<RuleModel> itemModel, GeoServerDataProvider.Property<RuleModel> property) {
                if (property == RulesModel.EDIT_BUTTON) {
                    return new EditButtonPanel(id, (RuleModel)itemModel.getObject());
                }
                if (property == RulesModel.ACTIVATE_BUTTON) {
                    return new ActivateButtonPanel(id, (RuleModel)itemModel.getObject());
                }
                return null;
            }
        };
        componentArray[0] = this.rulesPanel;
        this.add(componentArray);
        this.rulesPanel.setOutputMarkupId(true);
        RuleTestModel ruleTestModel = new RuleTestModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)ruleTestModel));
        this.add(new Component[]{form});
        TextArea input = new TextArea("input", (IModel)new PropertyModel((Object)ruleTestModel, "input"));
        form.add(new Component[]{input});
        input.setDefaultModelObject((Object)"/geoserver/tiger/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&CQL_FILTER=CFCC%3D%27H11%27");
        final TextArea output = new TextArea("output", (IModel)new PropertyModel((Object)ruleTestModel, "output"));
        output.setEnabled(false);
        form.add(new Component[]{output});
        form.add(new Component[]{new SubmitLink("test"){

            public void onSubmit() {
                Object outputText;
                if (ParamsExtractorConfigPage.this.rulesPanel.getSelection().isEmpty()) {
                    output.setModelObject((Object)"NO RULES SELECTED !");
                    return;
                }
                try {
                    RuleTestModel ruleTestModel = (RuleTestModel)this.getForm().getModelObject();
                    String[] urlParts = ruleTestModel.getInput().split("\\?");
                    String requestUri = urlParts[0];
                    Optional<String> queryRequest = urlParts.length > 1 ? Optional.ofNullable(urlParts[1]) : Optional.empty();
                    UrlTransform urlTransform = new UrlTransform(requestUri, Utils.parseParameters(queryRequest));
                    ParamsExtractorConfigPage.this.rulesPanel.getSelection().stream().filter(rule -> !rule.isEchoOnly()).map(RuleModel::toRule).forEach(rule -> rule.apply(urlTransform));
                    outputText = urlTransform.haveChanged() ? urlTransform.toString() : "NO RULES APPLIED !";
                }
                catch (Exception exception) {
                    outputText = "Exception: " + exception.getMessage();
                }
                output.setModelObject(outputText);
            }
        }});
    }

    private Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new AjaxLink<Object>("addNew"){

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new ParamsExtractorRulePage(Optional.empty()));
            }
        }});
        header.add(new Component[]{new AjaxLink<Object>("removeSelected"){

            public void onClick(AjaxRequestTarget target) {
                RulesModel.delete((String[])ParamsExtractorConfigPage.this.rulesPanel.getSelection().stream().map(RuleModel::getId).toArray(String[]::new));
                target.add(new Component[]{ParamsExtractorConfigPage.this.rulesPanel});
            }
        }});
        return header;
    }

    private class ActivateButtonPanel
    extends Panel {
        public ActivateButtonPanel(String id, final RuleModel ruleModel) {
            super(id);
            this.setOutputMarkupId(true);
            CheckBox activateButton = new CheckBox("activated", (IModel)new PropertyModel((Object)ruleModel, "activated"));
            activateButton.add(new Behavior[]{new FormComponentUpdatingBehavior(){

                public void onUpdate() {
                    RulesModel.saveOrUpdate(ruleModel);
                }
            }});
            this.add(new Component[]{activateButton});
        }
    }

    private class EditButtonPanel
    extends Panel {
        public EditButtonPanel(String id, final RuleModel ruleModel) {
            super(id);
            this.setOutputMarkupId(true);
            ImageAjaxLink<Object> editLink = new ImageAjaxLink<Object>("edit", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/edit.png")){

                protected void onClick(AjaxRequestTarget target) {
                    this.setResponsePage((IRequestablePage)new ParamsExtractorRulePage(Optional.of(ruleModel)));
                }
            };
            editLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("ParamsExtractorConfigPage.edit", (Component)editLink, new Object[0]))});
            editLink.setOutputMarkupId(true);
            this.add(new Component[]{editLink});
        }
    }
}

