/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParameterBuilder;
import org.geoserver.params.extractor.EchoParameterConverter;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.RestException;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.converters.XStreamXMLMessageConverter;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.rest.wrapper.RestWrapperAdapter;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/params-extractor/echoes"}, produces={"application/xml", "application/json", "text/json"})
public class EchoesController
extends RestBaseController {
    static final String ECHOES_ROOT = "/rest/params-extractor/echoes";

    @GetMapping
    public RestListWrapper<EchoParameter> getEchoParameters() {
        return new RestListWrapper(EchoParametersDao.getEchoParameters(), EchoParameter.class, (RestBaseController)this, "id", null);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> postEchoParameter(@RequestBody EchoParameter newValue) throws URISyntaxException {
        newValue = new EchoParameterBuilder().copy(newValue).withId(UUID.randomUUID().toString()).build();
        EchoParametersDao.saveOrUpdateEchoParameter(newValue);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(new URI(RequestInfo.get().pageURI(newValue.getId())));
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)newValue.getId(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @GetMapping(path={"{id}"})
    public RestWrapper<EchoParameter> getEchoParameter(@PathVariable String id) {
        EchoParameter result = EchoParametersDao.getEchoParameters().stream().filter(ep -> id.equals(ep.getId())).findFirst().orElseThrow(() -> new RestException("Parameter with id " + id + " not found", HttpStatus.NOT_FOUND));
        return new RestWrapperAdapter((Object)result, EchoParameter.class, (RestBaseController)this);
    }

    @DeleteMapping(path={"{id}"})
    public void deleteEchoParameter(@PathVariable String id) {
        this.getEchoParameter(id);
        EchoParametersDao.deleteEchoParameters(id);
    }

    @PutMapping(path={"{id}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void putEchoParameter(@RequestBody EchoParameter newValue, @PathVariable String id) {
        this.getEchoParameter(id);
        if (newValue.getId() == null) {
            newValue = new EchoParameterBuilder().copy(newValue).withId(id).build();
        } else if (!newValue.getId().equals(id)) {
            throw new RestException("Incosistent identifier, body uses " + newValue.getId() + " but REST API path has " + id, HttpStatus.BAD_REQUEST);
        }
        EchoParametersDao.saveOrUpdateEchoParameter(newValue);
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        super.configurePersister(persister, converter);
        XStream xStream = persister.getXStream();
        xStream.alias("EchoParameter", EchoParameter.class);
        xStream.allowTypeHierarchy(EchoParameter.class);
        if (converter instanceof XStreamXMLMessageConverter) {
            xStream.registerConverter((Converter)new EchoParameterConverter());
        }
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return EchoParameter.class.isAssignableFrom(methodParameter.getParameterType());
    }
}

