/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleBuilder;

public class RuleConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        String[] properties;
        Rule rule = (Rule)source;
        for (String property : properties = new String[]{"id", "activated", "position", "match", "activation", "parameter", "transform", "remove", "combine", "repeat"}) {
            Object value = OwsUtils.get((Object)rule, (String)property);
            if (value == null) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.addAttribute(property, (String)value);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RuleBuilder builder = new RuleBuilder();
        builder.withId(Optional.ofNullable(reader.getAttribute("id")).orElse(UUID.randomUUID().toString()));
        this.addParameter(reader, "activated", builder::withActivated, Boolean::valueOf);
        this.addParameter(reader, "position", builder::withPosition, Integer::valueOf);
        this.addParameter(reader, "match", builder::withMatch);
        this.addParameter(reader, "activation", builder::withActivation);
        this.addParameter(reader, "parameter", builder::withParameter);
        this.addParameter(reader, "transform", builder::withTransform);
        this.addParameter(reader, "remove", builder::withRemove, Integer::valueOf);
        this.addParameter(reader, "combine", builder::withCombine);
        this.addParameter(reader, "repeat", builder::withRepeat, Boolean::valueOf);
        return builder.build();
    }

    private <T> void addParameter(HierarchicalStreamReader reader, String attributeName, Consumer<T> consumer) {
        this.addParameter(reader, attributeName, consumer, null);
    }

    private <T> void addParameter(HierarchicalStreamReader reader, String attributeName, Consumer<T> consumer, Function<String, T> converter) {
        String value = reader.getAttribute(attributeName);
        if (value != null) {
            String converted = converter != null ? converter.apply(value) : value;
            consumer.accept(converted);
        }
    }

    public boolean canConvert(Class type) {
        return Rule.class.equals((Object)type);
    }
}

