/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.List;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleBuilder;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.TestSupport;
import org.geoserver.platform.resource.Resource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public final class RulesDaoTest
extends TestSupport {
    static List<Rule> getRules() {
        return RulesDao.getRules();
    }

    static List<Rule> getRules(String path) {
        return RulesDao.getRules((Resource)RulesDaoTest.getResource(path));
    }

    @Test
    public void testParsingEmptyFile() {
        List<Rule> rules = RulesDaoTest.getRules("data/rules1.xml");
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testParsingEmptyRules() {
        List<Rule> rules = RulesDaoTest.getRules("data/rules2.xml");
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testParsingPositionRule() {
        List<Rule> rules = RulesDaoTest.getRules("data/rules3.xml");
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(rules.get(0), new RuleBuilder().withId("0").withPosition(Integer.valueOf(3)).withParameter("cql_filter").withRemove(Integer.valueOf(1)).withTransform("seq='$2'").build());
    }

    @Test
    public void testParsingMatchRule() {
        List<Rule> rules = RulesDaoTest.getRules("data/rules4.xml");
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(rules.get(0), new RuleBuilder().withId("0").withMatch("^.*?(/([^/]+?))/[^/]+$").withParameter("cql_filter").withRemove(Integer.valueOf(1)).withTransform("seq='$2'").build());
    }

    @Test
    public void testParsingMultipleRules() {
        List<Rule> rules = RulesDaoTest.getRules("data/rules5.xml");
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)3));
        this.checkRule(this.findRule("0", rules), new RuleBuilder().withId("0").withPosition(Integer.valueOf(3)).withParameter("cql_filter").withRemove(Integer.valueOf(1)).withTransform("seq='$2'").build());
        this.checkRule(this.findRule("1", rules), new RuleBuilder().withId("1").withMatch("^.*?(/([^/]+?))/[^/]+$").withParameter("cql_filter").withRemove(Integer.valueOf(2)).withTransform("seq='$2'").build());
        this.checkRule(this.findRule("2", rules), new RuleBuilder().withId("2").withPosition(Integer.valueOf(4)).withParameter("cql_filter").withRemove(null).withTransform("seq='$2'").build());
    }

    @Test
    public void testParsingCombineRepeatRule() {
        List<Rule> rules = RulesDaoTest.getRules("data/rules6.xml");
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(rules.get(0), new RuleBuilder().withId("0").withMatch("^.*?(/([^/]+?))/[^/]+$").withParameter("cql_filter").withRemove(Integer.valueOf(1)).withTransform("seq='$2'").withCombine("$1;$2").withRepeat(Boolean.valueOf(true)).build());
    }

    @Test
    public void testRuleCrud() {
        Rule ruleA = new RuleBuilder().withId("0").withActivated(Boolean.valueOf(true)).withPosition(Integer.valueOf(3)).withParameter("cql_filter").withTransform("CFCC='$2'").build();
        Rule ruleB = new RuleBuilder().withId("1").withActivated(Boolean.valueOf(true)).withMatch("^(?:/[^/]*){3}(/([^/]+)).*$").withParameter("cql_filter").withActivation("^.*$").withTransform("CFCC='$2'").withRemove(Integer.valueOf(1)).withCombine("$1 AND $2").build();
        Rule ruleC = new RuleBuilder().withId("1").withActivated(Boolean.valueOf(false)).withMatch("^(?:/[^/]*){4}(/([^/]+)).*$").withParameter("cql_filter").withActivation("^.*$").withTransform("CFCC='$2'").withRemove(Integer.valueOf(1)).withCombine("$1 OR $2").build();
        List<Rule> rules = RulesDaoTest.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)0));
        RulesDao.saveOrUpdateRule((Rule)ruleA);
        RulesDao.saveOrUpdateRule((Rule)ruleB);
        rules = RulesDaoTest.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)2));
        this.checkRule(ruleA, this.findRule("0", rules));
        this.checkRule(ruleB, this.findRule("1", rules));
        RulesDao.saveOrUpdateRule((Rule)ruleC);
        rules = RulesDaoTest.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)2));
        this.checkRule(ruleA, this.findRule("0", rules));
        this.checkRule(ruleC, this.findRule("1", rules));
        RulesDao.deleteRules((String[])new String[]{"0"});
        rules = RulesDaoTest.getRules();
        MatcherAssert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)1));
        this.checkRule(ruleC, this.findRule("1", rules));
    }
}

