/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.params.extractor.RequestWrapper;
import org.geoserver.params.extractor.UrlTransform;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class RequestWrapperTest {
    @Test
    public void testServletPath() {
        UrlTransform urlTransform = new UrlTransform("/geoserver/it.geosolutions/wms/what", this.buildParameters());
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://127.0.0.1/geoserver/it.geosolutions/wms/what");
        RequestWrapper requestWrapper = new RequestWrapper(urlTransform, (HttpServletRequest)request);
        Assert.assertEquals((Object)"/geoserver", (Object)requestWrapper.getServletPath());
    }

    @Test
    public void testServletPathWithQueryParams() {
        UrlTransform urlTransform = new UrlTransform("/geoserver/it.geosolutions/wms/what?parameter=value", this.buildParameters());
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://127.0.0.1/geoserver/it.geosolutions/wms/what?parameter=value");
        RequestWrapper requestWrapper = new RequestWrapper(urlTransform, (HttpServletRequest)request);
        Assert.assertEquals((Object)"/geoserver", (Object)requestWrapper.getServletPath());
    }

    @Test
    public void testPathInfo() {
        UrlTransform urlTransform = new UrlTransform("/geoserver/it.geosolutions/wms/what", this.buildParameters());
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://127.0.0.1/geoserver/it.geosolutions/wms/what");
        RequestWrapper requestWrapper = new RequestWrapper(urlTransform, (HttpServletRequest)request);
        Assert.assertEquals((Object)"/it.geosolutions/wms/what", (Object)requestWrapper.getPathInfo());
    }

    @Test
    public void testPathInfoWithQueryParams() {
        UrlTransform urlTransform = new UrlTransform("/geoserver/it.geosolutions/wms/what/?parameter=value", this.buildParameters());
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://127.0.0.1/geoserver/it.geosolutions/wms/what/?parameter=value");
        RequestWrapper requestWrapper = new RequestWrapper(urlTransform, (HttpServletRequest)request);
        Assert.assertEquals((Object)"/it.geosolutions/wms/what", (Object)requestWrapper.getPathInfo());
    }

    private Map<String, String[]> buildParameters() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("test", new String[]{"1", "2"});
        return params;
    }
}

