/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geotools.util.logging.Logging;

public class FeaturesGetFeature
extends GetFeature {
    static final Logger LOGGER = Logging.getLogger(FeaturesGetFeature.class);

    public FeaturesGetFeature(WFSInfo wfs, Catalog catalog) {
        super(wfs, catalog);
    }

    protected void buildPrevNextLinks(GetFeatureRequest request, int offset, int maxFeatures, int count, FeatureCollectionResponse result, Map<String, String> kvp) {
        List queries = request.getQueries();
        if (queries == null || queries.size() != 1 || ((Query)queries.get(0)).getTypeNames() == null || ((Query)queries.get(0)).getTypeNames().size() != 1) {
            LOGGER.log(Level.INFO, "Cannot build prev/next links, the target typename is not known (or multiple type names available)");
            return;
        }
        QName typeName = (QName)((Query)queries.get(0)).getTypeNames().get(0);
        FeatureTypeInfo typeInfo = this.getCatalog().getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        if (typeInfo == null) {
            LOGGER.log(Level.INFO, "Cannot build prev/next links, the target typename was not found: " + typeName);
            return;
        }
        String collectionName = typeInfo.prefixedName();
        String itemsPath = this.getItemsPath(collectionName);
        kvp = APIRequestInfo.get().getSimpleQueryMap();
        if (offset > 0) {
            int prevOffset = Math.max(offset - maxFeatures, 0);
            kvp.put("startIndex", String.valueOf(prevOffset));
            kvp.put("limit", String.valueOf(offset - prevOffset));
            result.setPrevious(this.buildURL(itemsPath, kvp));
        }
        if (count > 0 && offset > -1 && maxFeatures <= count) {
            kvp.put("startIndex", String.valueOf(offset > 0 ? offset + count : count));
            kvp.put("limit", String.valueOf(maxFeatures));
            result.setNext(this.buildURL(itemsPath, kvp));
        }
    }

    protected String getItemsPath(String collectionName) {
        return "ogc/features/v1/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/items";
    }

    private String buildURL(String itemsPath, Map<String, String> kvp) {
        return ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)itemsPath, kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }
}

