/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIConformance;
import org.geoserver.ogcapi.ConformanceInfo;
import org.geoserver.wfs.WFSInfo;

public class ECQLConformance
extends ConformanceInfo<WFSInfo> {
    public static final String METADATA_KEY = "ecql";
    public static final APIConformance ECQL = new APIConformance("http://geoserver.org/spec/ecql/1.0/req/gs-ecql", APIConformance.Level.COMMUNITY_STANDARD);
    public static final APIConformance ECQL_TEXT = new APIConformance("http://geoserver.org/spec/ecql/1.0/req/ecql-text", APIConformance.Level.COMMUNITY_STANDARD);
    private Boolean ecql = null;
    private Boolean text = null;

    public boolean isEnabled(WFSInfo serviceInfo) {
        return this.ecql(serviceInfo);
    }

    public static ECQLConformance configuration(WFSInfo wfsInfo) {
        if (wfsInfo.getMetadata().containsKey((Object)METADATA_KEY)) {
            return (ECQLConformance)((Object)wfsInfo.getMetadata().get((Object)METADATA_KEY));
        }
        ECQLConformance conf = new ECQLConformance();
        wfsInfo.getMetadata().put(METADATA_KEY, (Serializable)((Object)conf));
        return conf;
    }

    public List<APIConformance> conformances(WFSInfo wfsInfo) {
        ArrayList<APIConformance> conformanceList = new ArrayList<APIConformance>();
        if (this.isEnabled(wfsInfo)) {
            conformanceList.add(ECQL);
            if (this.text(wfsInfo)) {
                conformanceList.add(ECQL_TEXT);
            }
        }
        return conformanceList;
    }

    public Boolean isECQL() {
        return this.ecql;
    }

    public boolean ecql(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.ecql, ECQL);
    }

    public void setECQL(Boolean enabled) {
        this.ecql = enabled;
    }

    public Boolean isText() {
        return this.text;
    }

    public boolean text(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.text, ECQL_TEXT);
    }

    public void setText(Boolean enabled) {
        this.text = enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ECQLConformance");
        sb.append(" ").append(METADATA_KEY);
        sb.append("{ ecql=").append(this.ecql);
        sb.append("{ text=").append(this.text);
        sb.append('}');
        return sb.toString();
    }
}

