/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.features.CollectionDocument;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.platform.ServiceException;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;

@JacksonXmlRootElement(localName="Collections", namespace="http://www.opengis.net/wfs/3.0")
@JsonPropertyOrder(value={"links", "collections"})
public class CollectionsDocument
extends AbstractDocument {
    static final Logger LOGGER = Logging.getLogger(CollectionsDocument.class);
    private final GeoServer geoServer;
    private final List<String> crs;
    private final List<Consumer<CollectionDocument>> collectionDecorators = new ArrayList<Consumer<CollectionDocument>>();
    private final boolean skipInvalid;

    public CollectionsDocument(GeoServer geoServer, List<String> crsList) {
        this.geoServer = geoServer;
        this.crs = crsList;
        String path = "ogc/features/v1/collections/";
        this.addSelfLinks(path);
        this.skipInvalid = geoServer.getGlobal().getResourceErrorHandling() == ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
    }

    @JacksonXmlProperty(localName="Links")
    public List<Link> getLinks() {
        return this.links;
    }

    @JacksonXmlProperty(localName="Collection")
    public Iterator<CollectionDocument> getCollections() {
        final CloseableIterator featureTypes = this.geoServer.getCatalog().list(FeatureTypeInfo.class, (Filter)Filter.INCLUDE);
        return new Iterator<CollectionDocument>(){
            CollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (featureTypes.hasNext()) {
                    FeatureTypeInfo featureType = (FeatureTypeInfo)featureTypes.next();
                    try {
                        this.next = CollectionsDocument.this.getCollectionDocument(featureType, (CloseableIterator<FeatureTypeInfo>)featureTypes);
                        return true;
                    }
                    catch (Exception e) {
                        if (CollectionsDocument.this.skipInvalid) {
                            LOGGER.log(Level.WARNING, "Skipping feature type " + featureType);
                            continue;
                        }
                        featureTypes.close();
                        throw new ServiceException("Failed to iterate over the feature types in the catalog", (Throwable)e);
                    }
                }
                return this.next != null;
            }

            @Override
            public CollectionDocument next() {
                CollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    private CollectionDocument getCollectionDocument(FeatureTypeInfo featureType, CloseableIterator<FeatureTypeInfo> featureTypes) throws IOException {
        List<String> crs = FeatureService.getFeatureTypeCRS(featureType, Collections.singletonList("#/crs"));
        CollectionDocument collection = new CollectionDocument(this.geoServer, featureType, crs, this.crs);
        for (Consumer<CollectionDocument> collectionDecorator : this.collectionDecorators) {
            collectionDecorator.accept(collection);
        }
        return collection;
    }

    public List<String> getCrs() {
        return this.crs;
    }

    public void addCollectionDecorator(Consumer<CollectionDocument> decorator) {
        this.collectionDecorators.add(decorator);
    }
}

