/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.Queryables;
import org.geoserver.ogcapi.TimeExtentCalculator;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.springframework.http.MediaType;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "links"})
@JacksonXmlRootElement(localName="Collection", namespace="http://www.opengis.net/wfs/3.0")
public class CollectionDocument
extends AbstractCollectionDocument<FeatureTypeInfo> {
    static final Logger LOGGER = Logging.getLogger(CollectionDocument.class);
    FeatureTypeInfo featureType;
    String mapPreviewURL;
    List<String> crs;
    String storageCrs;

    public CollectionDocument(GeoServer geoServer, FeatureTypeInfo featureType, List<String> crs) throws IOException {
        this(geoServer, featureType, crs, null);
    }

    public CollectionDocument(GeoServer geoServer, FeatureTypeInfo featureType, List<String> crs, List<String> serviceCRS) throws IOException {
        super((Object)featureType);
        Map<String, String> kvp;
        String collectionId;
        this.id = collectionId = featureType.prefixedName();
        this.title = featureType.getTitle();
        this.description = featureType.getAbstract();
        DateRange timeExtent = TimeExtentCalculator.getTimeExtent((ResourceInfo)featureType);
        ReferencedEnvelope bbox = featureType.getLatLonBoundingBox();
        int numDecimals = geoServer.getSettings().getNumDecimals();
        ReferencedEnvelope roundedOutBounds = this.roundLonLatBbox(bbox, numDecimals);
        this.setExtent(new CollectionExtents(roundedOutBounds, timeExtent));
        this.featureType = featureType;
        this.storageCrs = this.lookupStorageCrs();
        if (crs == null) {
            this.crs = List.of(this.storageCrs);
        } else if (!this.crsListContains(this.storageCrs, crs, serviceCRS)) {
            this.crs = new ArrayList<String>(crs);
            this.crs.add(0, this.storageCrs);
        } else {
            this.crs = crs;
        }
        Collection formats = APIRequestInfo.get().getProducibleMediaTypes(FeaturesResponse.class, true);
        String baseUrl = APIRequestInfo.get().getBaseURL();
        for (MediaType format : formats) {
            String apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/features/v1/collections/" + collectionId + "/items"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.addLink(new Link(apiUrl, "items", format.toString(), collectionId + " items as " + format.toString(), "items"));
        }
        this.addSelfLinks("ogc/features/v1/collections/" + this.id);
        if (CollectionDocument.isOWSAvailable(geoServer, "WFS")) {
            kvp = Map.ofEntries(Map.entry("service", "WFS"), Map.entry("version", "2.0"), Map.entry("request", "DescribeFeatureType"), Map.entry("typenames", featureType.prefixedName()));
            String describedByHref = ResponseUtils.buildURL((String)baseUrl, (String)"wfs", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            Link describedBy = new Link(describedByHref, "describedBy", "application/xml", "Schema for " + this.id);
            this.addLink(describedBy);
        }
        new LinksBuilder(Queryables.class, "ogc/features/v1/collections").segment(featureType.prefixedName(), true).segment("queryables").title("Queryable attributes as ").rel("http://www.opengis.net/def/rel/ogc/1.0/queryables").add((AbstractDocument)this);
        if (CollectionDocument.isOWSAvailable(geoServer, "WMS")) {
            kvp = new HashMap<String, String>();
            kvp.put("LAYERS", featureType.prefixedName());
            kvp.put("FORMAT", "application/openlayers");
            this.mapPreviewURL = ResponseUtils.buildURL((String)baseUrl, (String)"wms/reflect", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
    }

    private ReferencedEnvelope roundLonLatBbox(ReferencedEnvelope bbox, int numDecimals) {
        double minX = Math.max(-180.0, this.round(bbox.getMinX(), numDecimals, RoundingMode.FLOOR));
        double minY = Math.max(-90.0, this.round(bbox.getMinY(), numDecimals, RoundingMode.FLOOR));
        double maxX = Math.min(180.0, this.round(bbox.getMaxX(), numDecimals, RoundingMode.CEILING));
        double maxY = Math.min(90.0, this.round(bbox.getMaxY(), numDecimals, RoundingMode.CEILING));
        if (bbox.getWidth() == 0.0) {
            maxX = minX;
        }
        if (bbox.getHeight() == 0.0) {
            maxY = minY;
        }
        return new ReferencedEnvelope(minX, maxX, minY, maxY, bbox.getCoordinateReferenceSystem());
    }

    double round(double value, int places, RoundingMode mode) {
        if (places < 0) {
            throw new IllegalArgumentException("Decimal places must be non-negative");
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, mode);
        return bd.doubleValue();
    }

    private boolean crsListContains(String storageCrs, List<String> collectionCRSs, List<String> serviceCRSs) {
        if (collectionCRSs.contains("#/crs") && serviceCRSs != null && serviceCRSs.contains(storageCrs)) {
            return true;
        }
        return collectionCRSs.contains(storageCrs);
    }

    private static boolean isOWSAvailable(GeoServer geoServer, String serviceId) {
        return geoServer.getServices().stream().anyMatch(s -> serviceId.equalsIgnoreCase(s.getName()) && s.isEnabled());
    }

    private String lookupStorageCrs() {
        CoordinateReferenceSystem crs = this.getSchemaCRS();
        if (crs != null) {
            try {
                return FeatureService.getCRSURI(crs);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.FINER, "Error looking up epsg code", e);
            }
        }
        return null;
    }

    private CoordinateReferenceSystem getSchemaCRS() {
        FeatureType schema = this.getSchema();
        if (schema != null) {
            return schema.getCoordinateReferenceSystem();
        }
        return null;
    }

    @JsonIgnore
    public FeatureType getSchema() {
        try {
            return this.featureType.getFeatureType();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to compute feature type", e);
            return null;
        }
    }

    @JsonIgnore
    public String getMapPreviewURL() {
        return this.mapPreviewURL;
    }

    public List<String> getCrs() {
        return this.crs;
    }

    public String getStorageCrs() {
        return this.storageCrs;
    }
}

