/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonParser;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.SchemaLoader;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class QueryablesTest
extends FeaturesTestSupport {
    @Test
    public void testDefaultFormat() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(this.roadSegmentQueryables(), 200);
        Assert.assertEquals((Object)"application/schema+json", (Object)response.getContentType());
        this.checkRoadSegmentsQueryables(response);
    }

    @Test
    public void testFullFormatParameter() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(this.roadSegmentQueryables() + "?f=application/schema%2Bjson", 200);
        Assert.assertEquals((Object)"application/schema+json", (Object)response.getContentType());
        this.checkRoadSegmentsQueryables(response);
    }

    private String roadSegmentQueryables() {
        return "ogc/features/v1/collections/" + this.getLayerId(CiteTestData.ROAD_SEGMENTS) + "/queryables";
    }

    @Test
    public void testAcceptHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest(this.roadSegmentQueryables());
        request.setMethod("GET");
        request.addHeader("Accept", (Object)"application/schema+json");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.checkRoadSegmentsQueryables(response);
    }

    private void checkRoadSegmentsQueryables(MockHttpServletResponse response) throws UnsupportedEncodingException {
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"geometry-multilinestring", (Object)json.read("properties.the_geom.format", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)json.read("properties.FID.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)json.read("properties.FID.title", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)json.read("properties.NAME.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)json.read("properties.NAME.title", new Predicate[0]));
        Assert.assertEquals((Object)"https://json-schema.org/draft/2020-12/schema", (Object)this.readSingle(json, ".$schema"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ARoadSegments/queryables", (Object)this.readSingle(json, ".$id"));
        Assert.assertEquals((Object)"object", (Object)json.read("type", new Predicate[0]));
        Assert.assertEquals((Object)3, (Object)json.read("$..links.length()", Integer.class, new Predicate[0]));
        DocumentContext selfLink = this.readSingleContext(json, "links[?(@.rel=='self')]");
        Assert.assertEquals((Object)"application/schema+json", (Object)selfLink.read("type", new Predicate[0]));
        DocumentContext htmlLink = this.readSingleContext(json, "links[?(@.rel=='alternate' && @.type=='text/html')]");
        MatcherAssert.assertThat((Object)((String)htmlLink.read("href", new Predicate[0])), (Matcher)Matchers.endsWith((String)"queryables?f=text%2Fhtml"));
        DocumentContext yamlLink = this.readSingleContext(json, "links[?(@.rel=='alternate' && @.type=='application/yaml')]");
        MatcherAssert.assertThat((Object)((String)yamlLink.read("href", new Predicate[0])), (Matcher)Matchers.endsWith((String)"queryables?f=application%2Fyaml"));
    }

    @Test
    public void testQueryablesHTML() throws Exception {
        String roadSegments = MockData.ROAD_SEGMENTS.getLocalPart();
        Document document = this.getAsJSoup("cite/ogc/features/v1/collections/" + roadSegments + "/queryables?f=html");
        Assert.assertEquals((Object)"the_geom: MultiLineString", (Object)document.select("#queryables li:eq(0)").text());
    }

    @Test
    public void queryablesSchema() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(this.roadSegmentQueryables() + "?f=application/schema%2Bjson", 200);
        JsonValue schemaJSON = new JsonParser(response.getContentAsString()).parse();
        new SchemaLoader((IJsonValue)schemaJSON).load();
    }
}

