/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIFilterParser;
import org.geoserver.ogcapi.v1.features.FeatureConformance;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.geoserver.test.GeoServerBaseTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ApiTest
extends FeaturesTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiJson() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        FeatureConformance features = FeatureConformance.configuration((WFSInfo)wfs);
        features.setIDs(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/openapi", 200);
            this.validateJSONAPI(response);
        }
        finally {
            features.setIDs(null);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiJsonExtension() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        FeatureConformance features = FeatureConformance.configuration((WFSInfo)wfs);
        features.setIDs(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/openapi.json", 200);
            this.validateJSONAPI(response);
        }
        finally {
            features.setIDs(null);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    private void validateJSONAPI(MockHttpServletResponse response) throws UnsupportedEncodingException, JsonProcessingException {
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testHTMLEncoding() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        GeoServerBaseTestSupport.LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">"));
    }

    @Test
    public void testApiHTML() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/openapi?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-32x32.png\" sizes=\"32x32\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-16x16.png\" sizes=\"16x16\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-bundle.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-standalone-preset.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/api.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<input type=\"hidden\" id=\"apiLocation\" value=\"http://localhost:8080/geoserver/ogc/features/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0\"/>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"<script>")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiYaml() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        FeatureConformance features = FeatureConformance.configuration((WFSInfo)wfs);
        features.setIDs(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String yaml = this.getAsString("ogc/features/v1/openapi?f=application/yaml");
            this.validateYAMLApi(yaml);
        }
        finally {
            features.setIDs(null);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiYamlExtension() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        FeatureConformance features = FeatureConformance.configuration((WFSInfo)wfs);
        features.setIDs(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String yaml = this.getAsString("ogc/features/v1/openapi?f=application/yaml");
            this.validateYAMLApi(yaml);
        }
        finally {
            features.setIDs(null);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    private void validateYAMLApi(String yaml) throws JsonProcessingException {
        GeoServerBaseTestSupport.LOGGER.log(Level.INFO, yaml);
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testYamlAsAcceptsHeader() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        FeatureConformance features = FeatureConformance.configuration((WFSInfo)wfs);
        features.setIDs(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            MockHttpServletRequest request = this.createRequest("ogc/features/v1/openapi");
            request.setMethod("GET");
            request.setContent(new byte[0]);
            request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
            MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/yaml"));
            String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
            ObjectMapper mapper = Yaml.mapper();
            OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
            this.validateApi(api);
        }
        finally {
            features.setIDs(null);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    private void validateApi(OpenAPI api) {
        List servers = api.getServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/features/v1"));
        Assert.assertEquals((Object)"1.0.1", (Object)api.getInfo().getVersion());
        Paths paths = api.getPaths();
        PathItem landing = (PathItem)paths.get((Object)"/");
        Assert.assertNotNull((Object)landing);
        MatcherAssert.assertThat((Object)landing.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getLandingPage"));
        PathItem conformance = (PathItem)paths.get((Object)"/conformance");
        Assert.assertNotNull((Object)conformance);
        MatcherAssert.assertThat((Object)conformance.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getConformanceDeclaration"));
        PathItem collections = (PathItem)paths.get((Object)"/collections");
        Assert.assertNotNull((Object)collections);
        MatcherAssert.assertThat((Object)collections.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getCollections"));
        PathItem collection = (PathItem)paths.get((Object)"/collections/{collectionId}");
        Assert.assertNotNull((Object)collection);
        MatcherAssert.assertThat((Object)collection.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"describeCollection"));
        PathItem items = (PathItem)paths.get((Object)"/collections/{collectionId}/items");
        Assert.assertNotNull((Object)items);
        Operation itemsGet = items.getGet();
        MatcherAssert.assertThat((Object)itemsGet.getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getFeatures"));
        List parameters = itemsGet.getParameters();
        List itemGetParamNames = parameters.stream().map(p -> p.get$ref()).collect(Collectors.toList());
        MatcherAssert.assertThat(itemGetParamNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"#/components/parameters/collectionId", "#/components/parameters/limit", "#/components/parameters/bbox", "#/components/parameters/datetime", "#/components/parameters/filter", "#/components/parameters/filter-lang", "#/components/parameters/filter-crs", "#/components/parameters/sortby", "#/components/parameters/crs", "#/components/parameters/bbox-crs", "#/components/parameters/otherParameters", "#/components/parameters/ids"}));
        Parameter langs = (Parameter)api.getComponents().getParameters().get("filter-lang");
        Assert.assertEquals(Arrays.asList(APIFilterParser.ECQL_TEXT, APIFilterParser.CQL2_TEXT), (Object)langs.getSchema().getEnum());
        PathItem item = (PathItem)paths.get((Object)"/collections/{collectionId}/items/{featureId}");
        Assert.assertNotNull((Object)item);
        MatcherAssert.assertThat((Object)item.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getFeature"));
        Map params = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)params.get("collectionId");
        List collectionIdValues = collectionId.getSchema().getEnum();
        List expectedCollectionIds = this.getCatalog().getFeatureTypes().stream().map(ft -> ft.prefixedName()).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collectionIdValues, (Matcher)CoreMatchers.equalTo(expectedCollectionIds));
        Parameter limit = (Parameter)params.get("limit");
        Schema limitSchema = limit.getSchema();
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)limitSchema.getMinimum());
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        Assert.assertEquals((long)wfs.getMaxFeatures(), (long)limitSchema.getMaximum().intValue());
        Assert.assertEquals((long)wfs.getMaxFeatures(), (long)((Number)limitSchema.getDefault()).intValue());
    }

    @Test
    public void testWorkspaceQualifiedAPI() throws Exception {
        MockHttpServletRequest request = this.createRequest("cdf/ogc/features/v1/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/yaml", (Object)response.getContentType());
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        Map params = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)params.get("collectionId");
        List collectionIdValues = collectionId.getSchema().getEnum();
        List expectedCollectionIds = this.getCatalog().getFeatureTypesByNamespace(this.getCatalog().getNamespaceByPrefix("cdf")).stream().map(ft -> ft.getName()).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collectionIdValues, (Matcher)CoreMatchers.equalTo(expectedCollectionIds));
    }

    @Test
    @Ignore
    public void testFilterCRS() throws Exception {
        Assert.fail((String)"We should to enumerate all supported filter-crs values, but they are likely too many, and we'd have to inspect all the collections to find an exhaustive list for the test. The ATS does not seem to check it either, so taking a not but not implementing for the time being.");
    }
}

