/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIFilterParser;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.features.CQL2Conformance;
import org.geoserver.ogcapi.v1.features.CollectionsDocument;
import org.geoserver.ogcapi.v1.features.ECQLConformance;
import org.geoserver.ogcapi.v1.features.FeatureConformance;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.wfs.WFSInfo;

public class FeaturesAPIBuilder
extends OpenAPIBuilder<WFSInfo> {
    public FeaturesAPIBuilder() {
        super(FeaturesAPIBuilder.class, "openapi.yaml", "Features 1.0 server", FeatureService.class);
    }

    public OpenAPI build(WFSInfo wfs) throws IOException {
        OpenAPI api = super.build((ServiceInfo)wfs);
        FeatureConformance features = FeatureConformance.configuration(wfs);
        CQL2Conformance cql2 = CQL2Conformance.configuration(wfs);
        ECQLConformance ecql = ECQLConformance.configuration(wfs);
        if (!features.search(wfs)) {
            api.getPaths().remove((Object)"/collections/{collectionId}/search");
        }
        if (!features.queryables(wfs)) {
            api.getPaths().remove((Object)"/collections/{collectionId}/queryables");
        }
        if (!cql2.functions(wfs)) {
            api.getPaths().remove((Object)"/functions");
        }
        api.externalDocs(new ExternalDocumentation().description("WFS specification").url("https://github.com/opengeospatial/WFS_FES"));
        this.declareGetResponseFormats(api, "/", OpenAPI.class);
        this.declareGetResponseFormats(api, "/conformance", ConformanceDocument.class);
        this.declareGetResponseFormats(api, "/collections", CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/items", FeaturesResponse.class);
        List itemsParameters = ((PathItem)api.getPaths().get((Object)"/collections/{collectionId}/items")).getGet().getParameters();
        if (!features.filter(wfs)) {
            itemsParameters.removeIf(p -> p.get$ref().equals("#/components/parameters/filter"));
            itemsParameters.removeIf(p -> p.get$ref().equals("#/components/parameters/filter-lang"));
        }
        if (!features.crsByReference(wfs)) {
            itemsParameters.removeIf(p -> p.get$ref().equals("#/components/parameters/filter-crs"));
        }
        if (!features.ids(wfs)) {
            itemsParameters.removeIf(p -> p.get$ref().equals("#/components/parameters/ids"));
        }
        if (!features.sortBy(wfs)) {
            itemsParameters.removeIf(p -> p.get$ref().equals("#/components/parameters/filter-sortby"));
        }
        this.declareGetResponseFormats(api, "/collections/{collectionId}/items/{featureId}", FeaturesResponse.class);
        Content itemsContent = ((ApiResponse)((PathItem)api.getPaths().get((Object)"/collections/{collectionId}/items/{featureId}")).getGet().getResponses().get((Object)"200")).getContent();
        if (!features.gml321(wfs)) {
            itemsContent.remove((Object)"application/gml+xml;version=3.2");
        }
        Map parameters = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)parameters.get("collectionId");
        Catalog catalog = wfs.getGeoServer().getCatalog();
        List validCollectionIds = catalog.getFeatureTypes().stream().filter(ft -> ft.isEnabled() && ft.isAdvertised()).map(ft -> ft.prefixedName()).collect(Collectors.toList());
        collectionId.getSchema().setEnum(validCollectionIds);
        Parameter filterLang = (Parameter)parameters.get("filter-lang");
        ArrayList filterLangValues = new ArrayList(APIFilterParser.SUPPORTED_ENCODINGS);
        if (!cql2.text(wfs)) {
            filterLangValues.remove(APIFilterParser.CQL2_TEXT);
        }
        if (!cql2.json(wfs)) {
            filterLangValues.remove(APIFilterParser.CQL2_JSON);
        }
        if (!ecql.isEnabled(wfs)) {
            filterLangValues.remove(APIFilterParser.ECQL_TEXT);
        }
        filterLang.getSchema().setEnum(filterLangValues);
        Parameter limit = (Parameter)parameters.get("limit");
        BigDecimal limitMax = wfs.getMaxFeatures() > 0 ? BigDecimal.valueOf(wfs.getMaxFeatures()) : BigDecimal.valueOf(Integer.MAX_VALUE);
        limit.getSchema().setMaximum(limitMax);
        limit.getSchema().setDefault((Object)limitMax);
        return api;
    }
}

