/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import net.minidev.json.JSONArray;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFSInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class CollectionsTest
extends FeaturesTestSupport {
    public static final String BASIC_POLYGONS_TITLE = "Basic polygons";
    public static final String BASIC_POLYGONS_DESCRIPTION = "I love basic polygons!";
    public static final String MISCONFIGURED_TITLE = "Misconfigured";
    public static final String MISCONFIGURED_DESCRIPTION = "I am misconfigured";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        FeatureTypeInfo basicPolygons = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        basicPolygons.setTitle(BASIC_POLYGONS_TITLE);
        basicPolygons.setAbstract(BASIC_POLYGONS_DESCRIPTION);
        basicPolygons.setOverridingServiceSRS(true);
        basicPolygons.getResponseSRS().addAll(Arrays.asList("3857", "32632"));
        this.getCatalog().save((ResourceInfo)basicPolygons);
    }

    @Before
    public void revertChanges() throws IOException {
        this.revertLayer(MockData.BUILDINGS);
    }

    @Test
    public void testCollectionsJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections", 200);
        this.testCollectionsJson(json);
    }

    @Test
    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        FeatureTypeInfo misconfigured = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BUILDINGS));
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections", 200);
        int expected = this.getCatalog().getFeatureTypes().size();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        misconfigured.setLatLonBoundingBox(null);
        this.getCatalog().save((ResourceInfo)misconfigured);
        DocumentContext json2 = this.getAsJSONPath("ogc/features/v1/collections", 200);
        Assert.assertEquals((long)(expected - 1), (long)((Integer)json2.read("collections.length()", Integer.class, new Predicate[0])).intValue());
    }

    private void testCollectionsJson(DocumentContext json) throws Exception {
        int expected = this.getCatalog().getFeatureTypes().size();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        List formats = ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)applicationContext)).getProducibleMediaTypes(FeaturesResponse.class, true);
        MatcherAssert.assertThat((Object)formats.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)json.read("collections[0].links.length()", Integer.class, new Predicate[0]))));
        for (Object format : formats) {
            List items = (List)json.read("collections[0].links[?(@.type=='" + (MediaType)format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)"items", item.get("rel"));
        }
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5000)));
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/IAU/0/1000"}));
        crs.remove("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        for (String c : crs) {
            Assert.assertTrue((String)(c + " is not using the expect CRS URI format"), (boolean)c.matches("http://www.opengis.net/def/crs/[\\w]+/\\d+/\\d+"));
        }
        List collectionCRS = (List)json.read("collections[?(@.id == 'cite:Bridges')].crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)collectionCRS, (Matcher)Matchers.contains((Object[])new Object[]{Arrays.asList("#/crs")}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("collections[?(@.id=='cite:BasicPolygons')].crs", new Predicate[0])), (Matcher)Matchers.contains((Object[])new List[]{Arrays.asList("http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/32632")}));
    }

    @Test
    public void testCollectionsWorkspaceSpecificJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("cdf/ogc/features/v1/collections", 200);
        long expected = this.getCatalog().getFeatureTypes().stream().filter(ft -> "cdf".equals(ft.getStore().getWorkspace().getName())).count();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Collection)json.read("collections[?(@.id=='Deletes')]", new Predicate[0])), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)((Collection)json.read("collections[?(@.id=='cdf__Deletes')]", new Predicate[0])), (Matcher)Matchers.empty());
        String deleteHrefPath = "collections[?(@.id=='Deletes')].links[?(@.rel=='items' && @.type=='application/geo+json')].href";
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/cdf/ogc/features/v1/collections/Deletes/items?f=application%2Fgeo%2Bjson", (Object)((JSONArray)json.read("collections[?(@.id=='Deletes')].links[?(@.rel=='items' && @.type=='application/geo+json')].href", new Predicate[0])).get(0));
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/features/v1/collections/?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testCollectionsJson((DocumentContext)json);
    }

    @Test
    public void testCollectionsHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/features/v1/collections?f=html");
        List featureTypes = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo featureType : featureTypes) {
            String encodedName = featureType.prefixedName().replace(":", "__");
            Assert.assertNotNull((Object)document.select("#html_" + encodedName + "_link"));
            Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/features/v1/collections/" + featureType.prefixedName() + "/items?f=text%2Fhtml&limit=50"), (Object)document.select("#html_" + encodedName + "_link").attr("href"));
        }
        FeatureTypeInfo basicPolygons = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        String basicPolygonsName = basicPolygons.prefixedName();
        String basicPolygonsHtmlId = basicPolygonsName.replace(":", "__");
        Assert.assertEquals((Object)BASIC_POLYGONS_TITLE, (Object)document.select("#" + basicPolygonsHtmlId + "_title").text());
        Assert.assertEquals((Object)BASIC_POLYGONS_DESCRIPTION, (Object)document.select("#" + basicPolygonsHtmlId + "_description").text());
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)document.select("#" + basicPolygonsHtmlId + "_storageCrs").text());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectionsHTMLWithProxyBase() throws Exception {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo info = gs.getGlobal();
        SettingsInfo settings = info.getSettings();
        settings.setProxyBaseUrl("http://testHost/geoserver");
        gs.save(info);
        try {
            Document document = this.getAsJSoup("ogc/features/v1/collections?f=html");
            List featureTypes = this.getCatalog().getFeatureTypes();
            for (FeatureTypeInfo featureType : featureTypes) {
                String encodedName = featureType.prefixedName().replace(":", "__");
                Assert.assertNotNull((Object)document.select("#html_" + encodedName + "_link"));
                Assert.assertEquals((Object)("http://testHost/geoserver/ogc/features/v1/collections/" + featureType.prefixedName() + "/items?f=text%2Fhtml&limit=50"), (Object)document.select("#html_" + encodedName + "_link").attr("href"));
            }
        }
        finally {
            info = gs.getGlobal();
            settings = info.getSettings();
            settings.setProxyBaseUrl(null);
            gs.save(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectionsHTMLWithProxyBaseHeader() throws Exception {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo info = gs.getGlobal();
        SettingsInfo settings = info.getSettings();
        settings.setProxyBaseUrl("${X-Forwarded-Proto}://test-headers/geoserver/");
        info.getSettings().setUseHeadersProxyURL(Boolean.valueOf(true));
        gs.save(info);
        try {
            MockHttpServletRequest request = this.createRequest("ogc/features/v1/collections?f=html");
            request.setMethod("GET");
            request.setContent(new byte[0]);
            request.addHeader("X-Forwarded-Proto", (Object)"http");
            MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
            LOGGER.log(Level.INFO, "Last request returned\n:" + response.getContentAsString());
            Document document = Jsoup.parse((String)response.getContentAsString());
            List featureTypes = this.getCatalog().getFeatureTypes();
            for (FeatureTypeInfo featureType : featureTypes) {
                String encodedName = featureType.prefixedName().replace(":", "__");
                Assert.assertNotNull((Object)document.select("#html_" + encodedName + "_link"));
                Assert.assertEquals((String)encodedName, (Object)("http://test-headers/geoserver/ogc/features/v1/collections/" + featureType.prefixedName() + "/items?f=text%2Fhtml&limit=50"), (Object)document.select("#html_" + encodedName + "_link").attr("href"));
            }
        }
        finally {
            info = gs.getGlobal();
            settings = info.getSettings();
            settings.setProxyBaseUrl(null);
            info.getSettings().setUseHeadersProxyURL(null);
            gs.save(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomCRSList() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        List srs = wfs.getSRS();
        srs.add("3857");
        srs.add("32632");
        try {
            gs.save((ServiceInfo)wfs);
            DocumentContext json = this.getAsJSONPath("cdf/ogc/features/v1/collections", 200);
            List crs = (List)json.read("crs", new Predicate[0]);
            MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.contains((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/32632"}));
        }
        finally {
            wfs.getSRS().clear();
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testCustomLinks() throws Exception {
        GeoServerInfo gsi = this.getGeoServer().getGlobal();
        LinkInfoImpl link1 = new LinkInfoImpl("enclosure", "application/geopackage+sqlite3", "http://example.com/fullDataset.gpkg");
        LinkInfoImpl link2 = new LinkInfoImpl("license", "text/html", "http://example.com/license");
        link2.setService("Coverages");
        ArrayList links = Stream.of(link1, link2).collect(Collectors.toCollection(ArrayList::new));
        gsi.getSettings().getMetadata().put("ogcApiLinks", (Serializable)links);
        this.getGeoServer().save(gsi);
        DocumentContext json = this.getAsJSONPath("cite/ogc/features/v1/collections/", 200);
        DocumentContext l1c = this.readSingleContext(json, "$.links[?(@.rel=='enclosure')]");
        Assert.assertEquals((Object)link1.getHref(), (Object)l1c.read("href", new Predicate[0]));
        Assert.assertEquals((Object)link1.getType(), (Object)l1c.read("type", new Predicate[0]));
        List l2List = (List)json.read("$.links[?(@.rel=='rasterized')]", List.class, new Predicate[0]);
        Assert.assertTrue((boolean)l2List.isEmpty());
    }
}

