/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.Wcs10Factory;
import net.opengis.wcs11.DescribeCoverageType;
import net.opengis.wcs11.DomainSubsetType;
import net.opengis.wcs11.Wcs11Factory;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.Wfs20Factory;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.monitor.BBoxAsserts;
import org.geoserver.monitor.MemoryMonitorDAO;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.MonitorTestData;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.ows.MonitorCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.NameImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class MonitorCallbackTest {
    static Monitor monitor;
    MonitorCallback callback;
    RequestData data;
    static Catalog catalog;

    public static Filter parseFilter(String cql) {
        try {
            return CQL.toFilter((String)cql);
        }
        catch (CQLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @BeforeClass
    public static void setUpData() throws Exception {
        MemoryMonitorDAO dao = new MemoryMonitorDAO();
        new MonitorTestData((MonitorDAO)dao).setup();
        MonitorConfig mc = new MonitorConfig(){

            public MonitorDAO createDAO() {
                MemoryMonitorDAO dao = new MemoryMonitorDAO();
                try {
                    new MonitorTestData((MonitorDAO)dao).setup();
                    return dao;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }

            public MonitorConfig.BboxMode getBboxMode() {
                return MonitorConfig.BboxMode.FULL;
            }
        };
        GeoServer gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        monitor = new Monitor(mc);
        monitor.setServer(gs);
        catalog = new CatalogImpl();
        EasyMock.expect((Object)gs.getCatalog()).andStubReturn((Object)catalog);
        EasyMock.replay((Object[])new Object[]{gs});
        NamespaceInfo ns = catalog.getFactory().createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = catalog.getFactory().createDataStore();
        FeatureTypeInfo ftFoo = catalog.getFactory().createFeatureType();
        ftFoo.setName("foo");
        ftFoo.setSRS("EPSG:4326");
        ftFoo.setNamespace(ns);
        ftFoo.setStore((StoreInfo)ds);
        catalog.add((ResourceInfo)ftFoo);
        FeatureTypeInfo ftBar = catalog.getFactory().createFeatureType();
        ftBar.setName("bar");
        ftBar.setSRS("EPSG:3348");
        ftBar.setNamespace(ns);
        ftBar.setStore((StoreInfo)ds);
        catalog.add((ResourceInfo)ftBar);
    }

    @Before
    public void setUp() throws Exception {
        this.callback = new MonitorCallback(monitor, catalog);
        this.data = monitor.start();
    }

    @After
    public void tearDown() throws Exception {
        monitor.complete();
    }

    @Test
    public void testBasic() throws Exception {
        this.callback.operationDispatched(new Request(), this.op("foo", "bar", "1.2.3", null));
        Assert.assertEquals((Object)"BAR", (Object)this.data.getService());
        Assert.assertEquals((Object)"foo", (Object)this.data.getOperation());
        Assert.assertEquals((Object)"1.2.3", (Object)this.data.getOwsVersion());
    }

    @Test
    public void testWFSDescribeFeatureType() throws Exception {
        DescribeFeatureTypeType dft = WfsFactory.eINSTANCE.createDescribeFeatureTypeType();
        dft.getTypeName().add((Object)new QName("http://acme.org", "foo", "acme"));
        dft.getTypeName().add((Object)new QName("http://acme.org", "bar", "acme"));
        Operation op = this.op("DescribeFeatureType", "WFS", "1.0.0", dft);
        this.callback.operationDispatched(new Request(), op);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
    }

    @Test
    public void testWFSGetFeature() throws Exception {
        GetFeatureType gf = WfsFactory.eINSTANCE.createGetFeatureType();
        Filter f1 = MonitorCallbackTest.parseFilter("BBOX(the_geom, 40, -90, 45, -60)");
        Filter f2 = MonitorCallbackTest.parseFilter("BBOX(the_geom, 5988504.35,851278.90, 7585113.55,1950872.01)");
        net.opengis.wfs.QueryType q = WfsFactory.eINSTANCE.createQueryType();
        q.setTypeName(Arrays.asList(new QName("http://acme.org", "foo", "acme")));
        q.setFilter(f1);
        gf.getQuery().add((Object)q);
        q = WfsFactory.eINSTANCE.createQueryType();
        q.setTypeName(Arrays.asList(new QName("http://acme.org", "bar", "acme")));
        gf.getQuery().add((Object)q);
        q.setFilter(f2);
        Operation op = this.op("GetFeature", "WFS", "1.0.0", gf);
        this.callback.operationDispatched(new Request(), op);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
        ReferencedEnvelope expected = new ReferencedEnvelope(53.73, 40.0, -60.0, -95.1193, CRS.decode((String)"EPSG:4326"));
        BBoxAsserts.assertEqualsBbox((BoundingBox)expected, this.data.getBbox(), 0.01);
    }

    @Test
    public void testWFSGetFeature20() throws Exception {
        net.opengis.wfs20.GetFeatureType gf = Wfs20Factory.eINSTANCE.createGetFeatureType();
        Filter f1 = MonitorCallbackTest.parseFilter("BBOX(the_geom, 40, -90, 45, -60)");
        Filter f2 = MonitorCallbackTest.parseFilter("BBOX(the_geom, 5988504.35,851278.90, 7585113.55,1950872.01)");
        QueryType q = Wfs20Factory.eINSTANCE.createQueryType();
        q.getTypeNames().addAll(Arrays.asList(new QName("http://acme.org", "foo", "acme")));
        q.setFilter(f1);
        gf.getAbstractQueryExpression().add((Object)q);
        q = Wfs20Factory.eINSTANCE.createQueryType();
        q.getTypeNames().addAll(Arrays.asList(new QName("http://acme.org", "bar", "acme")));
        gf.getAbstractQueryExpression().add((Object)q);
        q.setFilter(f2);
        Operation op = this.op("GetFeature", "WFS", "2.0.0", gf);
        this.callback.operationDispatched(new Request(), op);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
        ReferencedEnvelope expected = new ReferencedEnvelope(53.73, 40.0, -60.0, -95.1193, CRS.decode((String)"EPSG:4326"));
        BBoxAsserts.assertEqualsBbox((BoundingBox)expected, this.data.getBbox(), 0.01);
    }

    @Test
    public void testWFSLockFeature() throws Exception {
        LockFeatureType lf = WfsFactory.eINSTANCE.createLockFeatureType();
        LockType l = WfsFactory.eINSTANCE.createLockType();
        l.setTypeName(new QName("http://acme.org", "foo", "acme"));
        lf.getLock().add((Object)l);
        Operation op = this.op("LockFeature", "WFS", "1.0.0", lf);
        this.callback.operationDispatched(new Request(), op);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
    }

    @Test
    public void testWFSTransaction() throws Exception {
        TransactionType t = WfsFactory.eINSTANCE.createTransactionType();
        Filter f1 = MonitorCallbackTest.parseFilter("BBOX(the_geom, 40, -90, 45, -60)");
        Filter f2 = MonitorCallbackTest.parseFilter("BBOX(the_geom, 5988504.35,851278.90, 7585113.55,1950872.01)");
        UpdateElementType ue = WfsFactory.eINSTANCE.createUpdateElementType();
        ue.setTypeName(new QName("http://acme.org", "foo", "acme"));
        ue.setFilter(f1);
        t.getUpdate().add((Object)ue);
        DeleteElementType de = WfsFactory.eINSTANCE.createDeleteElementType();
        de.setTypeName(new QName("http://acme.org", "bar", "acme"));
        de.setFilter(f2);
        t.getDelete().add((Object)de);
        Operation op = this.op("Transaction", "WFS", "1.1.0", t);
        this.callback.operationDispatched(new Request(), op);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
        ReferencedEnvelope expected = new ReferencedEnvelope(53.73, 40.0, -60.0, -95.1193, CRS.decode((String)"EPSG:4326"));
        BBoxAsserts.assertEqualsBbox((BoundingBox)expected, this.data.getBbox(), 0.01);
    }

    @Test
    public void testWFSTransactionInsert() throws Exception {
        TransactionType t = WfsFactory.eINSTANCE.createTransactionType();
        InsertElementType ie = WfsFactory.eINSTANCE.createInsertElementType();
        t.getInsert().add((Object)ie);
        ReferencedEnvelope expected = new ReferencedEnvelope(53.73, 40.0, -60.0, -95.1193, CRS.decode((String)"EPSG:4326"));
        SimpleFeatureType ft = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.expect((Object)ft.getTypeName()).andReturn((Object)"acme:foo").anyTimes();
        EasyMock.replay((Object[])new Object[]{ft});
        SimpleFeature f = (SimpleFeature)EasyMock.createNiceMock(SimpleFeature.class);
        EasyMock.expect((Object)f.getBounds()).andReturn((Object)expected).anyTimes();
        EasyMock.expect((Object)f.getType()).andReturn((Object)ft).anyTimes();
        EasyMock.replay((Object[])new Object[]{f});
        ie.getFeature().add((Object)f);
        Operation op = this.op("Transaction", "WFS", "1.1.0", t);
        this.callback.operationDispatched(new Request(), op);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox((BoundingBox)expected, this.data.getBbox(), 0.01);
    }

    @Test
    public void testWMSGetMap() throws Exception {
        GetMapRequest gm = new GetMapRequest();
        gm.setLayers(Arrays.asList(this.createMapLayer("foo", "acme")));
        Envelope env = new Envelope(100.0, 110.0, 70.0, 80.0);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        CoordinateReferenceSystem logCrs = CRS.decode((String)"EPSG:4326");
        gm.setBbox(env);
        gm.setCrs(crs);
        this.callback.operationDispatched(new Request(), this.op("GetMap", "WMS", "1.1.1", gm));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox(new ReferencedEnvelope(env, crs).toBounds(logCrs), this.data.getBbox(), 0.1);
    }

    @Test
    public void testWMSReflect() throws Exception {
        GetMapRequest gm = new GetMapRequest();
        gm.setLayers(Arrays.asList(this.createMapLayer("foo", "acme")));
        this.callback.operationDispatched(new Request(), this.op("reflect", "WMS", "1.1.1", gm));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
    }

    @Test
    public void testWMSGetFeatureInfo() throws Exception {
        GetFeatureInfoRequest gfi = new GetFeatureInfoRequest();
        GetMapRequest gm = new GetMapRequest();
        gm.setHeight(330);
        gm.setWidth(780);
        ReferencedEnvelope env = new ReferencedEnvelope(-126.81851, -115.818992, 44.852958, 49.5066, null);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        CoordinateReferenceSystem logCrs = CRS.decode((String)"EPSG:4326", (boolean)false);
        gm.setBbox((Envelope)env);
        gm.setCrs(crs);
        gfi.setGetMapRequest(gm);
        gfi.setXPixel(260);
        gfi.setYPixel(63);
        gfi.setVersion("1.1.1");
        gfi.setQueryLayers(Arrays.asList(this.createMapLayer("foo", "acme"), this.createMapLayer("bar", "acme")));
        this.callback.operationDispatched(new Request(), this.op("GetFeatureInfo", "WMS", "1.1.1", gfi));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
        BBoxAsserts.assertEqualsBbox((BoundingBox)new ReferencedEnvelope(48.62, 48.62, -123.15, -123.15, logCrs), this.data.getBbox(), 0.01);
    }

    @Test
    public void testWMSGetLegendGraphic() throws Exception {
        GetLegendGraphicRequest glg = new GetLegendGraphicRequest();
        FeatureType type = (FeatureType)EasyMock.createMock(FeatureType.class);
        EasyMock.expect((Object)type.getName()).andReturn((Object)new NameImpl("http://acme.org", "foo")).anyTimes();
        EasyMock.replay((Object[])new Object[]{type});
        glg.setLayer(type);
        this.callback.operationDispatched(new Request(), this.op("GetFeatureInfo", "WMS", "1.1.1", glg));
        Assert.assertEquals((Object)"http://acme.org:foo", this.data.getResources().get(0));
    }

    @Test
    public void testWCS10DescribeCoverage() throws Exception {
        net.opengis.wcs10.DescribeCoverageType dc = Wcs10Factory.eINSTANCE.createDescribeCoverageType();
        dc.getCoverage().add((Object)"acme:foo");
        dc.getCoverage().add((Object)"acme:bar");
        this.callback.operationDispatched(new Request(), this.op("DescribeCoverage", "WCS", "1.0.0", dc));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
    }

    @Test
    public void testWCS10GetCoverage() throws Exception {
        GetCoverageType gc = Wcs10Factory.eINSTANCE.createGetCoverageType();
        SpatialSubsetType spatialSubset = Wcs10Factory.eINSTANCE.createSpatialSubsetType();
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        GeneralBounds env = new GeneralBounds(new double[]{-123.4, 48.2}, new double[]{-120.9, 50.1});
        env.setCoordinateReferenceSystem(crs);
        ReferencedEnvelope bbox = new ReferencedEnvelope((Bounds)env);
        spatialSubset.getEnvelope().clear();
        spatialSubset.getEnvelope().add((Object)env);
        net.opengis.wcs10.DomainSubsetType domainSubset = Wcs10Factory.eINSTANCE.createDomainSubsetType();
        domainSubset.setSpatialSubset(spatialSubset);
        gc.setSourceCoverage("acme:foo");
        gc.setDomainSubset(domainSubset);
        this.callback.operationDispatched(new Request(), this.op("GetCoverage", "WCS", "1.0.0", gc));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox((BoundingBox)bbox, this.data.getBbox(), 0.1);
    }

    @Test
    public void testWCS11DescribeCoverage() throws Exception {
        DescribeCoverageType dc = Wcs11Factory.eINSTANCE.createDescribeCoverageType();
        dc.getIdentifier().add((Object)"acme:foo");
        dc.getIdentifier().add((Object)"acme:bar");
        this.callback.operationDispatched(new Request(), this.op("DescribeCoverage", "WCS", "1.1.0", dc));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
    }

    @Test
    public void testWCS11GetCoverage() throws Exception {
        net.opengis.wcs11.GetCoverageType gc = Wcs11Factory.eINSTANCE.createGetCoverageType();
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        GeneralBounds env = new GeneralBounds(new double[]{48.2, -123.4}, new double[]{50.1, -120.9});
        env.setCoordinateReferenceSystem(crs);
        ReferencedEnvelope bbox = new ReferencedEnvelope((Bounds)env);
        BoundingBoxType wcsBbox = Ows11Factory.eINSTANCE.createBoundingBoxType();
        wcsBbox.setLowerCorner(Arrays.asList(48.2, -123.4));
        wcsBbox.setUpperCorner(Arrays.asList(50.1, -120.9));
        wcsBbox.setCrs("urn:ogc:def:crs:EPSG:4326");
        DomainSubsetType domainSubset = Wcs11Factory.eINSTANCE.createDomainSubsetType();
        domainSubset.setBoundingBox(wcsBbox);
        gc.setDomainSubset(domainSubset);
        CodeType c = Ows11Factory.eINSTANCE.createCodeType();
        c.setValue("acme:bar");
        gc.setIdentifier(c);
        this.callback.operationDispatched(new Request(), this.op("GetCoverage", "WCS", "1.1.0", gc));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox((BoundingBox)bbox, this.data.getBbox(), 0.1);
    }

    MapLayerInfo createMapLayer(String name, String ns) {
        ResourceInfo r = (ResourceInfo)EasyMock.createMock(ResourceInfo.class);
        EasyMock.expect((Object)r.getName()).andReturn((Object)name);
        EasyMock.expect((Object)r.prefixedName()).andReturn((Object)(ns + ":" + name));
        EasyMock.expect((Object)r.getTitle()).andReturn((Object)name);
        EasyMock.expect((Object)r.getInternationalTitle()).andReturn(null);
        EasyMock.expect((Object)r.getAbstract()).andReturn((Object)name);
        EasyMock.expect((Object)r.getInternationalAbstract()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{r});
        LayerInfo l = (LayerInfo)EasyMock.createMock(LayerInfo.class);
        EasyMock.expect((Object)l.getResource()).andReturn((Object)r);
        EasyMock.expect((Object)l.getType()).andReturn((Object)PublishedType.VECTOR);
        EasyMock.replay((Object[])new Object[]{l});
        return new MapLayerInfo(l);
    }

    Operation op(String name, String service, String version, Object request) {
        return new Operation(name, new Service(service, null, new Version(version), null), null, new Object[]{request});
    }

    @Test
    public void testWCS10GetCoverageDifferentCrs() throws Exception {
        GetCoverageType gc = Wcs10Factory.eINSTANCE.createGetCoverageType();
        SpatialSubsetType spatialSubset = Wcs10Factory.eINSTANCE.createSpatialSubsetType();
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3348", (boolean)false);
        CoordinateReferenceSystem logCrs = CRS.decode((String)"EPSG:4326", (boolean)false);
        GeneralBounds env = new GeneralBounds(new double[]{5988504.35, 851278.9}, new double[]{7585113.55, 1950872.01});
        env.setCoordinateReferenceSystem(crs);
        ReferencedEnvelope bbox = new ReferencedEnvelope(42.2802, 53.73, -95.1193, -71.295, logCrs);
        spatialSubset.getEnvelope().clear();
        spatialSubset.getEnvelope().add((Object)env);
        net.opengis.wcs10.DomainSubsetType domainSubset = Wcs10Factory.eINSTANCE.createDomainSubsetType();
        domainSubset.setSpatialSubset(spatialSubset);
        gc.setSourceCoverage("acme:foo");
        gc.setDomainSubset(domainSubset);
        this.callback.operationDispatched(new Request(), this.op("GetCoverage", "WCS", "1.0.0", gc));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox((BoundingBox)bbox, this.data.getBbox(), 0.1);
    }

    @Test
    public void testWCS11GetCoverageDifferentCrs() throws Exception {
        net.opengis.wcs11.GetCoverageType gc = Wcs11Factory.eINSTANCE.createGetCoverageType();
        CoordinateReferenceSystem logCrs = CRS.decode((String)"EPSG:4326", (boolean)false);
        ReferencedEnvelope bbox = new ReferencedEnvelope(42.2802, 53.73, -95.1193, -71.295, logCrs);
        BoundingBoxType wcsBbox = Ows11Factory.eINSTANCE.createBoundingBoxType();
        wcsBbox.setLowerCorner(Arrays.asList(5988504.35, 851278.9));
        wcsBbox.setUpperCorner(Arrays.asList(7585113.55, 1950872.01));
        wcsBbox.setCrs("urn:ogc:def:crs:EPSG:3348");
        DomainSubsetType domainSubset = Wcs11Factory.eINSTANCE.createDomainSubsetType();
        domainSubset.setBoundingBox(wcsBbox);
        gc.setDomainSubset(domainSubset);
        CodeType c = Ows11Factory.eINSTANCE.createCodeType();
        c.setValue("acme:bar");
        gc.setIdentifier(c);
        this.callback.operationDispatched(new Request(), this.op("GetCoverage", "WCS", "1.1.0", gc));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox((BoundingBox)bbox, this.data.getBbox(), 0.1);
    }

    @Test
    public void testWMSGetMapDifferentCrs() throws Exception {
        GetMapRequest gm = new GetMapRequest();
        gm.setLayers(Arrays.asList(this.createMapLayer("foo", "acme")));
        Envelope env = new Envelope(5988504.35, 7585113.55, 851278.9, 1950872.01);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3348", (boolean)true);
        gm.setBbox(env);
        gm.setCrs(crs);
        this.callback.operationDispatched(new Request(), this.op("GetMap", "WMS", "1.1.1", gm));
        CoordinateReferenceSystem logCrs = CRS.decode((String)"EPSG:4326", (boolean)false);
        ReferencedEnvelope bbox = new ReferencedEnvelope(42.2802, 53.73, -95.1193, -71.295, logCrs);
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        BBoxAsserts.assertEqualsBbox((BoundingBox)bbox, this.data.getBbox(), 0.1);
    }

    @Test
    public void testWMSGetFeatureInfoDifferentCrs() throws Exception {
        GetFeatureInfoRequest gfi = new GetFeatureInfoRequest();
        GetMapRequest gm = new GetMapRequest();
        gm.setHeight(423);
        gm.setWidth(512);
        ReferencedEnvelope env = new ReferencedEnvelope(3833170.221556, 4083455.358596, 1841755.690829, 2048534.231783, null);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3348", (boolean)true);
        CoordinateReferenceSystem logCrs = CRS.decode((String)"EPSG:4326", (boolean)false);
        gm.setBbox((Envelope)env);
        gm.setCrs(crs);
        gfi.setGetMapRequest(gm);
        gfi.setXPixel(259);
        gfi.setYPixel(241);
        gfi.setVersion("1.1.1");
        gfi.setQueryLayers(Arrays.asList(this.createMapLayer("foo", "acme"), this.createMapLayer("bar", "acme")));
        this.callback.operationDispatched(new Request(), this.op("GetFeatureInfo", "WMS", "1.1.1", gfi));
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(0));
        Assert.assertEquals((Object)"acme:bar", this.data.getResources().get(1));
        BBoxAsserts.assertEqualsBbox((BoundingBox)new ReferencedEnvelope(48.4, 48.4, -123.3, -123.3, logCrs), this.data.getBbox(), 0.1);
    }

    @Test
    public void testConfiguration() throws IOException {
        Assert.assertTrue((boolean)monitor.getConfig().getFileLocations().isEmpty());
        File tmpDir = MonitorCallbackTest.createTempDir();
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(tmpDir);
        monitor.getConfig().saveConfiguration(resourceLoader);
        Resource controlFlowProps = Files.asResource((File)resourceLoader.find("monitor.properties"));
        Assert.assertTrue((boolean)Resources.exists((Resource)controlFlowProps));
        PropertyFileWatcher savedProps = new PropertyFileWatcher(controlFlowProps);
        Assert.assertEquals((Object)savedProps.getProperties(), (Object)monitor.getConfig().getProperties());
    }

    @Test
    public void testWMSGetLegendGraphicMissingFeatureType() {
        GetLegendGraphicRequest glg = new GetLegendGraphicRequest();
        glg.setLayer(null);
        this.callback.operationDispatched(new Request(), this.op("GetLegendGraphic", "WMS", "1.1.1", glg));
        List resources = this.data.getResources();
        Assert.assertEquals((Object)this.data.getOperation(), (Object)"GetLegendGraphic");
        Assert.assertNull((Object)resources);
    }

    static File createTempDir() throws IOException {
        File f = File.createTempFile("monitoring", "data", new File("target"));
        f.delete();
        f.mkdirs();
        return f;
    }
}

