/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.auditlog;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.auditlog.AuditLogger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.GenericApplicationContext;

public class AuditLoggerTest {
    @Rule
    public TemporaryFolder directory = new TemporaryFolder();
    private File bad;
    private File good;
    private GeoServerResourceLoader loader;
    private MonitorConfig config;
    private GenericApplicationContext context;

    @Before
    public void setUp() throws Exception {
        this.bad = this.directory.newFolder("bad");
        this.good = this.directory.newFolder("good");
        System.setProperty("GEOSERVER_AUDIT_PATH", this.good.getAbsolutePath());
        this.loader = new GeoServerResourceLoader(this.directory.getRoot());
        this.config = new MonitorConfig(this.loader);
        this.config.getProperties().put("audit.enabled", "true");
        this.config.getProperties().put("audit.path", this.bad.getAbsolutePath());
        this.context = new GenericApplicationContext();
        this.context.getBeanFactory().registerSingleton("resourceLoader", (Object)this.loader);
        this.context.refresh();
        new GeoServerExtensions().setApplicationContext((ApplicationContext)this.context);
    }

    @After
    public void tearDown() {
        System.clearProperty("GEOSERVER_AUDIT_PATH");
        new GeoServerExtensions().setApplicationContext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitDumperRaceCondition() throws Exception {
        int numTests = 10;
        int numRequests = 8;
        for (int i = 0; i < numTests; ++i) {
            AuditLogger logger = new AuditLogger(this.config, this.loader);
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(numRequests);
            for (int j = 0; j < numRequests; ++j) {
                RequestData data = new RequestData();
                data.setId(1L);
                data.setHost("localhost");
                data.setStartTime(new Date(0L));
                data.setEndTime(new Date(0L));
                tasks.add(Executors.callable(() -> logger.requestPostProcessed(data)));
            }
            ExecutorService executor = Executors.newFixedThreadPool(numRequests);
            try {
                for (Future future : executor.invokeAll(tasks)) {
                    future.get();
                }
                continue;
            }
            finally {
                executor.shutdownNow();
                logger.onApplicationEvent((ApplicationEvent)new ContextClosedEvent((ApplicationContext)this.context));
            }
        }
        MatcherAssert.assertThat((Object)this.bad.listFiles(), (Matcher)Matchers.emptyArray());
        File[] files = this.good.listFiles();
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.arrayWithSize((int)numTests));
        long size = files[0].length();
        MatcherAssert.assertThat((Object)size, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        for (int i = 1; i < numTests; ++i) {
            Assert.assertEquals((long)size, (long)files[i].length());
        }
    }
}

