/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.web;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.image.resource.BufferedDynamicImageResource;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.IResource;
import org.geoserver.monitor.Monitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public abstract class OWSSummaryChartBasePanel
extends Panel {
    private static final long serialVersionUID = 8914945614020025223L;
    protected String owsService;

    public OWSSummaryChartBasePanel(String id, Monitor monitor, String owsService) {
        super(id);
        this.owsService = owsService;
        Map<String, Integer> data = this.gatherData(monitor);
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Map.Entry<String, Integer> e : data.entrySet()) {
            dataset.setValue((Comparable)((Object)e.getKey()), (Number)e.getValue());
        }
        JFreeChart chart = ChartFactory.createPieChart((String)this.getChartTitle(), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        BufferedDynamicImageResource resource = new BufferedDynamicImageResource();
        resource.setImage(chart.createBufferedImage(650, 500));
        this.add(new Component[]{new NonCachingImage("chart", (IResource)resource)});
    }

    protected abstract Map<String, Integer> gatherData(Monitor var1);

    protected abstract String getChartTitle();
}

