/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.web;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.monitor.web.OWSSummaryChartBasePanel;

public class OWSOverviewPanel
extends OWSSummaryChartBasePanel {
    private static final long serialVersionUID = 103552954574455043L;

    public OWSOverviewPanel(String id, Monitor monitor, String owsService) {
        super(id, monitor, owsService);
    }

    @Override
    protected String getChartTitle() {
        return "OWS Request Summary";
    }

    @Override
    protected Map<String, Integer> gatherData(Monitor monitor) {
        Query q = new Query();
        q.properties("service").filter("service", null, Query.Comparison.NEQ);
        DataGatherer g = new DataGatherer();
        monitor.query(q, g);
        return g.getData();
    }

    class DataGatherer
    implements RequestDataVisitor {
        HashMap<String, Integer> data = new HashMap();

        DataGatherer() {
        }

        @Override
        public void visit(RequestData req, Object ... aggregates) {
            String service = req.getService();
            Integer count = this.data.get(service);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            this.data.put(service, count);
        }

        public HashMap<String, Integer> getData() {
            return this.data;
        }
    }
}

