/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;

public class LiveActivityPanel
extends Panel {
    private static final long serialVersionUID = -2807950039989311964L;

    public LiveActivityPanel(String id) {
        super(id);
        GeoServerTablePanel<RequestData> requests = new GeoServerTablePanel<RequestData>("requests", (GeoServerDataProvider)new LiveRequestDataProvider()){
            private static final long serialVersionUID = -431473636413825153L;

            protected Component getComponentForProperty(String id, IModel<RequestData> itemModel, GeoServerDataProvider.Property<RequestData> property) {
                Object prop = property.getPropertyValue((Object)((RequestData)itemModel.getObject()));
                String value = prop != null ? prop.toString() : "";
                return new Label(id, (Serializable)((Object)value));
            }
        };
        this.add(new Component[]{requests});
    }

    static class LiveRequestDataProvider
    extends GeoServerDataProvider<RequestData> {
        private static final long serialVersionUID = -5576324995486786071L;
        static final GeoServerDataProvider.Property<RequestData> ID = new GeoServerDataProvider.BeanProperty("id", "id");
        static final GeoServerDataProvider.Property<RequestData> PATH = new GeoServerDataProvider.BeanProperty("path", "path");
        static final GeoServerDataProvider.Property<RequestData> STATUS = new GeoServerDataProvider.BeanProperty("status", "status");

        LiveRequestDataProvider() {
        }

        protected List<RequestData> getItems() {
            MonitorDAO dao = ((Monitor)this.getApplication().getBeanOfType(Monitor.class)).getDAO();
            Query q = new Query().filter("status", Arrays.asList(RequestData.Status.RUNNING, RequestData.Status.WAITING, RequestData.Status.CANCELLING), Query.Comparison.IN);
            return dao.getRequests(q);
        }

        protected List<GeoServerDataProvider.Property<RequestData>> getProperties() {
            return Arrays.asList(ID, PATH, STATUS);
        }
    }
}

