/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.web;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.web.ActivityChartBasePanel;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;

public class DailyActivityPanel
extends ActivityChartBasePanel {
    private static final long serialVersionUID = -3347402344921524474L;

    public DailyActivityPanel(String id, Monitor monitor) {
        super(id, monitor);
    }

    @Override
    protected Date[] getDateRange() {
        Date now = Calendar.getInstance().getTime();
        Calendar then = Calendar.getInstance();
        then.setTime(now);
        then.set(11, 0);
        then.set(12, 0);
        then.set(13, 0);
        return new Date[]{then.getTime(), now};
    }

    @Override
    protected RegularTimePeriod getTimePeriod(Date time) {
        return new Second(time);
    }

    @Override
    protected String getChartTitle(Date[] range) {
        return "Activity " + new SimpleDateFormat("yyyy-MM-dd").format(range[0]);
    }
}

