/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.rest.BaseMonitorConverter;
import org.geoserver.monitor.rest.CSVMonitorConverter;
import org.geoserver.monitor.rest.MonitorQueryResults;
import org.geoserver.monitor.rest.MonitorRequestController;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class ZIPMonitorConverter
extends BaseMonitorConverter {
    CSVMonitorConverter csv = new CSVMonitorConverter();

    public ZIPMonitorConverter() {
        super(MonitorRequestController.ZIP_MEDIATYPE);
    }

    protected void writeInternal(MonitorQueryResults results, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Object object = results.getResult();
        Monitor monitor = results.getMonitor();
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(results.getFields()));
        boolean body = fields.remove("Body");
        boolean error = fields.remove("Error");
        ZipOutputStream zout = new ZipOutputStream(outputMessage.getBody());
        zout.putNextEntry(new ZipEntry("requests.csv"));
        String[] csvFields = fields.toArray(new String[fields.size()]);
        this.csv.writeCSVfile(object, csvFields, monitor, zout);
        if (object instanceof Query) {
            monitor.query((Query)object, (data, aggregates) -> {
                try {
                    this.writeBodyAndError((RequestData)data, zout, body, error, true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else if (object instanceof List) {
            for (RequestData data2 : (List)object) {
                this.writeBodyAndError(data2, zout, body, error, true);
            }
        } else {
            this.writeBodyAndError((RequestData)object, zout, body, error, false);
        }
        zout.flush();
        zout.close();
    }

    void writeBodyAndError(RequestData data, ZipOutputStream zout, boolean body, boolean error, boolean postfix) throws IOException {
        long id = data.getId();
        if (body && data.getBody() != null) {
            zout.putNextEntry(new ZipEntry((String)(postfix ? "body_" + id + ".txt" : "body.txt")));
            zout.write(data.getBody());
        }
        if (error && data.getError() != null) {
            zout.putNextEntry(new ZipEntry((String)(postfix ? "error_" + id + ".txt" : "error.txt")));
            data.getError().printStackTrace(new PrintStream(zout));
        }
    }
}

