/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.RequestData;
import org.geoserver.rest.AbstractGeoServerController;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.rest.DispatcherCallbackAdapter;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RESTMonitorCallback
extends DispatcherCallbackAdapter {
    static final Logger LOGGER = Logging.getLogger(RESTMonitorCallback.class);
    Monitor monitor;

    @Autowired
    public RESTMonitorCallback(Monitor monitor) {
        this.monitor = monitor;
    }

    public void init(HttpServletRequest request, HttpServletResponse response) {
        RequestData data = this.monitor.current();
        if (data == null) {
            return;
        }
        data.setCategory(RequestData.Category.REST);
        if (request.getPathInfo() != null) {
            String resource = request.getPathInfo();
            String[] pathParts = resource.split("/");
            data.getResources().add(pathParts[pathParts.length - 1]);
        }
        this.monitor.update();
    }

    public void dispatched(HttpServletRequest request, HttpServletResponse response, Object handler) {
        RequestData data = this.monitor.current();
        if (data == null) {
            return;
        }
        try {
            Object controllerBean = DispatcherCallback.getControllerBean((Object)handler);
            if (controllerBean instanceof AbstractCatalogController || controllerBean instanceof AbstractGeoServerController) {
                data.setService("RESTConfig");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error finding out if the call is a restconfig one", e);
        }
        this.monitor.update();
    }
}

