/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.monitor.rest.BaseMonitorConverter;
import org.geoserver.monitor.rest.MonitorQueryResults;
import org.geoserver.monitor.rest.MonitorRequestController;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.feature.type.DateUtil;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class CSVMonitorConverter
extends BaseMonitorConverter {
    static Pattern ESCAPE_REQUIRED = Pattern.compile("[\\,\\s\"]");

    public CSVMonitorConverter() {
        super(MonitorRequestController.CSV_MEDIATYPE);
    }

    protected void writeInternal(MonitorQueryResults results, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Object result = results.getResult();
        String[] fields = results.getFields();
        Monitor monitor = results.getMonitor();
        OutputStream os = outputMessage.getBody();
        this.writeCSVfile(result, fields, monitor, os);
    }

    void writeCSVfile(Object result, String[] fields, Monitor monitor, OutputStream os) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os));
        StringBuffer sb = new StringBuffer();
        for (String fld : fields) {
            sb.append(fld).append(",");
        }
        sb.setLength(sb.length() - 1);
        w.write(sb.append("\n").toString());
        CSVMonitorConverter.handleRequests(result, new CSVRequestDataVisitor(w, fields), monitor);
        w.flush();
    }

    private static final class CSVRequestDataVisitor
    implements RequestDataVisitor {
        private BufferedWriter writer;
        private String[] fields;

        CSVRequestDataVisitor(BufferedWriter writer, String[] fields) {
            this.writer = writer;
            this.fields = fields;
        }

        @Override
        public void visit(RequestData data, Object ... aggregates) {
            try {
                StringBuffer sb = new StringBuffer();
                for (String fld : this.fields) {
                    Object val = OwsUtils.get((Object)data, (String)fld);
                    if (val instanceof Date) {
                        val = DateUtil.serializeDateTime((Date)((Date)val));
                    }
                    if (val != null) {
                        String string = val.toString();
                        Matcher match = ESCAPE_REQUIRED.matcher(string);
                        if (match.find()) {
                            string = string.replaceAll("\"", "\"\"");
                            sb.append("\"");
                            sb.append(string);
                            sb.append("\"");
                        } else {
                            sb.append(string);
                        }
                    }
                    sb.append(",");
                }
                sb.setLength(sb.length() - 1);
                sb.append("\n");
                this.writer.write(sb.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

