/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows.wfs;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.ows.wfs.WFSRequestObjectHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.xsd.EMFUtils;

public class TransactionHandler
extends WFSRequestObjectHandler {
    public TransactionHandler(MonitorConfig config, Catalog catalog) {
        super("net.opengis.wfs.TransactionType", config, catalog);
    }

    @Override
    public void handle(Object request, RequestData data) {
        super.handle(request, data);
        FeatureMap elements = (FeatureMap)EMFUtils.get((EObject)((EObject)request), (String)"group");
        if (elements == null) {
            return;
        }
        FeatureMap.ValueListIterator i = elements.valueListIterator();
        int flag = 0;
        while (i.hasNext()) {
            Object e = i.next();
            if (e.getClass().getSimpleName().startsWith("Insert")) {
                flag |= 1;
                continue;
            }
            if (e.getClass().getSimpleName().startsWith("Update")) {
                flag |= 2;
                continue;
            }
            if (e.getClass().getSimpleName().startsWith("Delete")) {
                flag |= 4;
                continue;
            }
            flag |= 8;
        }
        StringBuffer sb = new StringBuffer();
        if (flag & true) {
            sb.append("I");
        }
        if ((flag & 2) == 2) {
            sb.append("U");
        }
        if ((flag & 4) == 4) {
            sb.append("D");
        }
        if ((flag & 8) == 8) {
            sb.append("O");
        }
        data.setSubOperation(sb.toString());
    }

    @Override
    public List<String> getLayers(Object request) {
        FeatureMap elements = (FeatureMap)EMFUtils.get((EObject)((EObject)request), (String)"group");
        if (elements == null) {
            return null;
        }
        ArrayList<String> layers = new ArrayList<String>();
        FeatureMap.ValueListIterator i = elements.valueListIterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (EMFUtils.has((EObject)((EObject)e), (String)"typeName")) {
                Object typeName = EMFUtils.get((EObject)((EObject)e), (String)"typeName");
                if (typeName == null) continue;
                layers.add(this.toString(typeName));
                continue;
            }
            if (!this.isInsert(e)) continue;
            List features = (List)EMFUtils.get((EObject)((EObject)e), (String)"feature");
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Feature f : features) {
                if (f instanceof SimpleFeature) {
                    set.add(((SimpleFeature)f).getType().getTypeName());
                    continue;
                }
                set.add(f.getType().getName().toString());
            }
            layers.addAll(set);
        }
        return layers;
    }

    @Override
    protected List<Object> getElements(Object request) {
        return (List)OwsUtils.get((Object)request, (String)"group");
    }

    @Override
    protected Object unwrapElement(Object element) {
        return OwsUtils.get((Object)element, (String)"value");
    }

    boolean isInsert(Object element) {
        return element.getClass().getSimpleName().startsWith("InsertElementType");
    }

    @Override
    protected ReferencedEnvelope getBBoxFromElement(Object element) {
        if (this.isInsert(element)) {
            Object srs;
            CoordinateReferenceSystem crs;
            ReferencedEnvelope bbox = null;
            if (OwsUtils.has((Object)element, (String)"srsName") && (crs = this.crs(srs = OwsUtils.get((Object)element, (String)"srsName"))) != null) {
                bbox = new ReferencedEnvelope(crs);
                bbox.setToNull();
            }
            List feature = (List)OwsUtils.get((Object)element, (String)"feature");
            for (Feature f : feature) {
                BoundingBox fbbox = f.getBounds();
                if (fbbox == null) continue;
                if (bbox == null) {
                    bbox = new ReferencedEnvelope(fbbox);
                }
                bbox.include(fbbox);
            }
            return bbox;
        }
        return null;
    }

    @Override
    protected CoordinateReferenceSystem getCrsFromElement(Object element) {
        CoordinateReferenceSystem crs;
        if (this.isInsert(element) && OwsUtils.has((Object)element, (String)"srsName") && (crs = this.crs(OwsUtils.get((Object)element, (String)"srsName"))) != null) {
            return crs;
        }
        return super.getCrsFromElement(element);
    }

    CoordinateReferenceSystem crs(Object srs) {
        try {
            return srs != null ? CRS.decode((String)srs.toString()) : null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }
}

