/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows.wcs11;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows11.CodeType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.ows.RequestObjectHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.EMFUtils;

public class GetCoverageHandler
extends RequestObjectHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");

    public GetCoverageHandler(MonitorConfig config) {
        super("net.opengis.wcs11.GetCoverageType", config);
    }

    @Override
    public List<String> getLayers(Object request) {
        CodeType id = (CodeType)EMFUtils.get((EObject)((EObject)request), (String)"identifier");
        return id != null ? Arrays.asList(id.getValue()) : null;
    }

    @Override
    protected BoundingBox getBBox(Object request) {
        Object domainSubset = OwsUtils.get((Object)request, (String)"domainSubset");
        Object wcsBbox = OwsUtils.get((Object)domainSubset, (String)"boundingBox");
        List upperCorner = (List)OwsUtils.get((Object)wcsBbox, (String)"upperCorner");
        List lowerCorner = (List)OwsUtils.get((Object)wcsBbox, (String)"lowerCorner");
        CoordinateReferenceSystem crs = null;
        String crsName = (String)OwsUtils.get((Object)wcsBbox, (String)"crs");
        try {
            crs = CRS.decode((String)crsName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Could not decode CRS ID: %s", crsName), e);
            return null;
        }
        double minX = (Double)lowerCorner.get(0);
        double maxX = (Double)upperCorner.get(0);
        double minY = (Double)lowerCorner.get(1);
        double maxY = (Double)upperCorner.get(1);
        try {
            return new ReferencedEnvelope(minX, maxX, minY, maxY, crs).toBounds(this.monitorConfig.getBboxCrs());
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not transform bounding box to logging CRS", e);
            return null;
        }
    }
}

