/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.auditlog;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geoserver.monitor.MemoryMonitorDAO;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataListener;
import org.geoserver.monitor.auditlog.AuditTemplateLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.template.TemplateUtils;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class AuditLogger
implements RequestDataListener,
ApplicationListener<ApplicationEvent> {
    static final String AUDIT = "audit";
    private static final Logger LOGGER = Logging.getLogger(MemoryMonitorDAO.class);
    private static final RequestData END_MARKER = new RequestData();
    public static final int DEFAULT_ROLLING_LIMIT = 10000;
    Configuration templateConfig;
    MonitorConfig config;
    volatile RequestDumper dumper;
    int rollLimit;
    String path;
    String headerTemplate;
    String contentTemplate;
    String footerTemplate;

    public AuditLogger(MonitorConfig config, GeoServerResourceLoader loader) throws IOException {
        this.config = config;
        this.templateConfig = TemplateUtils.getSafeConfiguration();
        this.templateConfig.setTemplateLoader((TemplateLoader)new AuditTemplateLoader(loader));
    }

    synchronized void initDumper() throws IOException {
        if (this.dumper == null && this.getProperty("enabled", Boolean.class, false).booleanValue()) {
            this.rollLimit = this.getProperty("roll_limit", Integer.class, 10000);
            this.path = System.getProperty("GEOSERVER_AUDIT_PATH");
            if (this.path == null || "".equals(this.path.trim())) {
                this.path = this.config.getProperty(AUDIT, "path", String.class);
            }
            this.headerTemplate = this.getProperty("ftl.header", String.class, null);
            this.contentTemplate = this.getProperty("ftl.content", String.class, null);
            this.footerTemplate = this.getProperty("ftl.footer", String.class, null);
            Resource loggingDir = Resources.fromPath((String)this.path);
            this.path = this.config.getProperty(AUDIT, "path", String.class);
            this.dumper = new RequestDumper(loggingDir.dir(), this.rollLimit, this.headerTemplate, this.contentTemplate, this.footerTemplate);
        }
    }

    <T> T getProperty(String name, Class<T> target, T defaultValue) {
        T value = this.config.getProperty(AUDIT, name, target);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public void requestStarted(RequestData rd) {
    }

    @Override
    public void requestUpdated(RequestData rd) {
    }

    @Override
    public void requestCompleted(RequestData rd) {
    }

    @Override
    public void requestPostProcessed(RequestData rd) {
        if (rd == null) {
            return;
        }
        try {
            if (this.dumper == null) {
                this.initDumper();
            } else {
                boolean enabled = this.getProperty("enabled", Boolean.class, false);
                if (!enabled) {
                    this.closeDumper(this.dumper);
                    this.dumper = null;
                } else {
                    int newLimit = this.getProperty("roll_limit", Integer.class, 10000);
                    String newPath = this.getProperty("path", String.class, null);
                    String newHeaderTemplate = this.getProperty("ftl.header", String.class, null);
                    String newContentTemplate = this.getProperty("ftl.content", String.class, null);
                    String newFooterTemplate = this.getProperty("ftl.footer", String.class, null);
                    if (!(newLimit == this.rollLimit && Objects.equals(newPath, this.path) && Objects.equals(newHeaderTemplate, this.headerTemplate) && Objects.equals(newContentTemplate, this.contentTemplate) && Objects.equals(newFooterTemplate, this.footerTemplate) && this.dumper.isAlive())) {
                        this.closeDumper(this.dumper);
                        this.dumper = null;
                        this.initDumper();
                    }
                }
            }
            if (this.dumper != null && !this.dumper.queue.offer(rd)) {
                LOGGER.log(Level.WARNING, "Auditing subsystem overload, the logging queue is full, stopping the world on it");
                this.dumper.queue.put(rd);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error occurred while trying to store the request data in the logger queue", e);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            this.closeDumper(this.dumper);
        }
    }

    private void closeDumper(RequestDumper dumper) {
        if (dumper != null) {
            dumper.exit();
            try {
                dumper.join(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to properly close the event dumper", e);
            }
        }
    }

    private final class RequestDumper
    extends Thread {
        private long lineCounter;
        private long fileRollCounter;
        BlockingQueue<RequestData> queue;
        private File logFile;
        private File path;
        private int day;
        private int lineRollingLimit;
        private String headerTemplate;
        private String contentTemplate;
        private String footerTemplate;

        private RequestDumper(File path, int lineRollingLimit, String headerTemplate, String contentTemplate, String footerTemplate) {
            super("RequestDumper");
            this.lineCounter = 0L;
            this.fileRollCounter = 0L;
            this.queue = new ArrayBlockingQueue<RequestData>(10000);
            this.day = -1;
            this.path = path;
            this.lineRollingLimit = lineRollingLimit;
            this.headerTemplate = headerTemplate == null ? "header.ftl" : headerTemplate;
            this.contentTemplate = contentTemplate == null ? "content.ftl" : contentTemplate;
            this.footerTemplate = contentTemplate == null ? "footer.ftl" : footerTemplate;
            this.setPriority(4);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            writer = null;
            while (true) {
                try {
                    rds = new ArrayList<RequestData>();
                    if (!this.queue.isEmpty()) {
                        this.queue.drainTo(rds);
                    } else {
                        rds.add(this.queue.take());
                    }
                    writer = this.rollWriter(writer);
                    template = AuditLogger.this.templateConfig.getTemplate(this.contentTemplate);
lbl13:
                    // 2 sources

                    for (RequestData rd : rds) {
                        if (rd == AuditLogger.END_MARKER) {
                            this.closeWriter(writer);
                            return;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl30
                }
                catch (Exception e) {
                    if (AuditLogger.LOGGER.isLoggable(Level.WARNING)) {
                        AuditLogger.LOGGER.log(Level.WARNING, "Request Dumper exiting due to :" + e.getLocalizedMessage(), e);
                    }
                    this.closeWriter(writer);
                    break;
                }
                catch (Throwable var6_8) {
                    this.closeWriter(writer);
                    throw var6_8;
                }
lbl-1000:
                // 1 sources

                {
                    template.process((Object)rd, (Writer)writer);
                    ++this.lineCounter;
                    ** GOTO lbl13
lbl30:
                    // 1 sources

                    try {
                        if (writer == null) continue;
                        writer.flush();
                    }
                    catch (Exception e) {
                        AuditLogger.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    continue;
                }
                break;
            }
            AuditLogger.LOGGER.info("Request Dumper stopped");
        }

        BufferedWriter rollWriter(BufferedWriter writer) throws Exception {
            GregorianCalendar current = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            if (this.lineCounter >= (long)this.lineRollingLimit || this.day > 0 && this.day != current.get(6) || this.logFile != null && !this.logFile.exists()) {
                this.closeWriter(writer);
                ++this.fileRollCounter;
                this.lineCounter = 0L;
                writer = null;
            }
            if (writer == null) {
                String[] files;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                String auditFileName = "geoserver_audit_" + dateFormat.format(current.getTime()) + "_";
                if (this.fileRollCounter == 0L && (files = this.path.list((FilenameFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)"geoserver_audit_"), FileFilterUtils.suffixFileFilter((String)".log")})))) != null && files.length > 0) {
                    Arrays.sort(files, (o1, o2) -> {
                        int dateCompare;
                        String[] o1s = o1.substring(0, o1.length() - 4).split("_");
                        String[] o2s = o2.substring(0, o2.length() - 4).split("_");
                        try {
                            dateCompare = dateFormat.parse(o1s[2]).compareTo(dateFormat.parse(o2s[2]));
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                        if (dateCompare == 0) {
                            return Integer.valueOf(o1s[3]).compareTo(Integer.valueOf(o2s[3]));
                        }
                        return dateCompare;
                    });
                    String target = files[files.length - 1];
                    int start = target.lastIndexOf("_") + 1;
                    int end = target.lastIndexOf(".");
                    this.fileRollCounter = Integer.parseInt(target.substring(start, end));
                    ++this.fileRollCounter;
                }
                this.logFile = new File(this.path, auditFileName + this.fileRollCounter + ".log");
                if (!this.logFile.exists() && !this.logFile.createNewFile()) {
                    throw new IllegalStateException("Unable to create monitoring file:" + this.logFile.getCanonicalPath());
                }
                this.day = new GregorianCalendar(TimeZone.getTimeZone("GMT")).get(6);
                writer = new BufferedWriter(new FileWriter(this.logFile, true));
                Template template = AuditLogger.this.templateConfig.getTemplate(this.headerTemplate);
                template.process(null, (Writer)writer);
            }
            return writer;
        }

        private void closeWriter(BufferedWriter writer) {
            block7: {
                block6: {
                    try {
                        if (writer != null) {
                            Template template = AuditLogger.this.templateConfig.getTemplate(this.footerTemplate);
                            template.process(null, (Writer)writer);
                            writer.flush();
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block6;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block7;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }

        public void exit() {
            if (this.queue != null && this.isAlive()) {
                block7: {
                    block6: {
                        try {
                            this.queue.put(END_MARKER);
                            this.join(1000L);
                        }
                        catch (InterruptedException e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block6;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    this.interrupt();
                    try {
                        this.join(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block7;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                if (this.isAlive()) {
                    this.stop();
                }
            }
        }
    }
}

