/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestPostProcessor;
import org.geotools.util.logging.Logging;

public class ReverseDNSPostProcessor
implements RequestPostProcessor {
    static final Logger LOGGER = Logging.getLogger(ReverseDNSPostProcessor.class);
    static final String PROCESSOR_NAME = "reverseDNS";
    final LoadingCache<String, String> reverseLookupCache;
    private static RequestPostProcessor INSTANCE;

    public ReverseDNSPostProcessor(MonitorConfig config) {
        LoadingCache cache;
        String cacheConfiguration = config.getDNSCacheConfiguration();
        try {
            cache = CacheBuilder.from((String)cacheConfiguration).build((CacheLoader)new DNSCacheLoader());
        }
        catch (Throwable e) {
            LOGGER.warning("Invalid config " + cacheConfiguration + ", reverting to default." + e.getMessage());
            cache = CacheBuilder.from((String)"expireAfterWrite=15m,maximumSize=1000").build((CacheLoader)new DNSCacheLoader());
        }
        this.reverseLookupCache = cache;
    }

    @Override
    public void run(RequestData data, HttpServletRequest request, HttpServletResponse response) {
        String host;
        String addr = data.getRemoteAddr();
        try {
            host = (String)this.reverseLookupCache.get((Object)addr);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.WARNING, "Internal error", e);
            host = addr;
        }
        data.setRemoteHost(host);
    }

    @Override
    public String getName() {
        return PROCESSOR_NAME;
    }

    public static synchronized RequestPostProcessor get(MonitorConfig config) {
        if (INSTANCE == null) {
            INSTANCE = new ReverseDNSPostProcessor(config);
        }
        return INSTANCE;
    }

    private static final class DNSCacheLoader
    extends CacheLoader<String, String> {
        private DNSCacheLoader() {
        }

        public String load(String remoteAddr) {
            try {
                InetAddress addr = InetAddress.getByName(remoteAddr);
                return addr.getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.FINE, "Error reverse looking up " + remoteAddr, e);
                return remoteAddr;
            }
        }
    }
}

