/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.api.geometry.BoundingBox;

public class RequestData
implements Serializable {
    private static final long serialVersionUID = 4115701065212157258L;
    private static AtomicLong COUNTER = new AtomicLong();
    public long internalid = COUNTER.getAndIncrement();
    private long id = -1L;
    private Status status = Status.WAITING;
    private Category category = Category.OTHER;
    private String path;
    private String queryString;
    private byte[] body;
    private long bodyContentLength;
    private String bodyContentType;
    private String httpMethod;
    private Date startTime;
    private Date endTime;
    private long totalTime;
    private String remoteAddr;
    private String remoteHost;
    private String remoteUser;
    private String remoteUserAgent;
    private String remoteCountry;
    private String remoteCity;
    private double remoteLat;
    private double remoteLon;
    private String host;
    private String internalHost;
    private String service;
    private String operation;
    private String owsVersion;
    private String subOperation;
    private List<String> resources = new ArrayList<String>(1);
    private long responseLength;
    private String responseContentType;
    private String errorMessage;
    private Throwable error;
    Integer responseStatus;
    private String httpReferer;
    private BoundingBox bbox;
    private String cacheResult;
    private String missReason;
    private List<Long> resourcesProcessingTime;
    private Long labellingProcessingTime;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public long getBodyContentLength() {
        return this.bodyContentLength;
    }

    public void setBodyContentLength(long bodyContentLength) {
        this.bodyContentLength = bodyContentLength;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    public void setBodyContentType(String bodyContentType) {
        this.bodyContentType = bodyContentType;
    }

    public String getBodyAsString() {
        if (this.body != null) {
            return new String(this.body);
        }
        return null;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getInternalHost() {
        return this.internalHost;
    }

    public void setInternalHost(String internalHost) {
        this.internalHost = internalHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUserAgent() {
        return this.remoteUserAgent;
    }

    public void setRemoteUserAgent(String remoteUserAgent) {
        this.remoteUserAgent = remoteUserAgent;
    }

    public String getRemoteCountry() {
        return this.remoteCountry;
    }

    public void setRemoteCountry(String remoteCountry) {
        this.remoteCountry = remoteCountry;
    }

    public String getRemoteCity() {
        return this.remoteCity;
    }

    public void setRemoteCity(String remoteCity) {
        this.remoteCity = remoteCity;
    }

    public double getRemoteLat() {
        return this.remoteLat;
    }

    public void setRemoteLat(double remoteLat) {
        this.remoteLat = remoteLat;
    }

    public double getRemoteLon() {
        return this.remoteLon;
    }

    public void setRemoteLon(double remoteLon) {
        this.remoteLon = remoteLon;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOwsVersion() {
        return this.owsVersion;
    }

    public void setOwsVersion(String owsVersion) {
        this.owsVersion = owsVersion;
    }

    public String getSubOperation() {
        return this.subOperation;
    }

    public void setSubOperation(String subOperation) {
        this.subOperation = subOperation;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResourcesList() {
        if (this.resources == null || this.resources.isEmpty()) {
            return null;
        }
        String result = this.resources.toString();
        return result.substring(1, result.length() - 1);
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public long getResponseLength() {
        return this.responseLength;
    }

    public void setResponseLength(long responseLength) {
        this.responseLength = responseLength;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public RequestData clone() {
        RequestData clone = new RequestData();
        clone.setId(this.id);
        clone.setStatus(this.status);
        clone.setPath(this.path);
        clone.setQueryString(this.queryString);
        clone.setBody(this.body);
        clone.setHttpMethod(this.httpMethod);
        clone.setStartTime(this.startTime);
        clone.setEndTime(this.endTime);
        clone.setTotalTime(this.totalTime);
        clone.setRemoteAddr(this.remoteAddr);
        clone.setRemoteHost(this.remoteHost);
        clone.setHost(this.host);
        clone.setInternalHost(this.internalHost);
        clone.setRemoteUser(this.remoteUser);
        clone.setService(this.service);
        clone.setOperation(this.operation);
        clone.setSubOperation(this.subOperation);
        clone.setOwsVersion(this.owsVersion);
        clone.setResources(new ArrayList<String>(this.resources));
        clone.setResponseLength(this.responseLength);
        clone.setResponseContentType(this.responseContentType);
        clone.setErrorMessage(this.errorMessage);
        clone.setError(this.error);
        clone.setResponseStatus(this.responseStatus);
        clone.setHttpReferer(this.httpReferer);
        clone.setBbox(this.bbox);
        clone.setCacheResult(this.cacheResult);
        clone.setMissReason(this.missReason);
        return clone;
    }

    public String toString() {
        return "Request (" + String.valueOf(this.id) + ")";
    }

    public Integer getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(Integer httpStatus) {
        this.responseStatus = httpStatus;
    }

    public String getHttpReferer() {
        return this.httpReferer;
    }

    public void setHttpReferer(String httpReferer) {
        this.httpReferer = httpReferer;
    }

    public BoundingBox getBbox() {
        return this.bbox;
    }

    public void setBbox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    public String getCacheResult() {
        return this.cacheResult;
    }

    public void setCacheResult(String cacheResult) {
        this.cacheResult = cacheResult;
    }

    public String getMissReason() {
        return this.missReason;
    }

    public void setMissReason(String missReason) {
        this.missReason = missReason;
    }

    public List<Long> getResourcesProcessingTime() {
        return this.resourcesProcessingTime;
    }

    public String getResourcesProcessingTimeList() {
        if (this.resourcesProcessingTime == null || this.resourcesProcessingTime.isEmpty()) {
            return null;
        }
        String times = this.resourcesProcessingTime.toString();
        return times.substring(1, times.length() - 1);
    }

    public void setResourcesProcessingTime(List<Long> resourcesProccessingTime) {
        this.resourcesProcessingTime = resourcesProccessingTime;
    }

    public Long getLabellingProcessingTime() {
        return this.labellingProcessingTime;
    }

    public void setLabellingProcessingTime(Long labellingProcessingTime) {
        this.labellingProcessingTime = labellingProcessingTime;
    }

    public static enum Category {
        OWS,
        REST,
        OTHER;

    }

    public static enum Status {
        WAITING,
        RUNNING,
        CANCELLING,
        FAILED,
        FINISHED,
        CANCELLED,
        INTERRUPTED;

    }
}

