/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MonitorServletResponse
extends HttpServletResponseWrapper {
    MonitorOutputStream output;
    int status = 200;

    public MonitorServletResponse(HttpServletResponse response) {
        super(response);
    }

    public long getContentLength() {
        if (this.output == null) {
            return 0L;
        }
        return this.output.getBytesWritten();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new MonitorOutputStream(super.getOutputStream());
        }
        return this.output;
    }

    public void setStatus(int sc) {
        this.status = sc;
        super.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.status = sc;
        super.setStatus(sc, sm);
    }

    public int getStatus() {
        return this.status;
    }

    static class MonitorOutputStream
    extends ServletOutputStream {
        long nbytes;
        ServletOutputStream delegate;

        public MonitorOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public long getBytesWritten() {
            return this.nbytes;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
            ++this.nbytes;
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            this.nbytes += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            this.nbytes += (long)len;
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }
    }
}

