/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MonitorServletRequest
extends HttpServletRequestWrapper {
    public static final long BODY_SIZE_UNBOUNDED = -1L;
    MonitorInputStream input;
    long maxSize;

    public MonitorServletRequest(HttpServletRequest request, long maxSize) {
        super(request);
        this.maxSize = maxSize;
    }

    public byte[] getBodyContent() throws IOException {
        MonitorInputStream stream = this.getInputStream();
        return stream.getData();
    }

    public long getBytesRead() {
        try {
            MonitorInputStream stream = this.getInputStream();
            return stream.getBytesRead();
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    public MonitorInputStream getInputStream() throws IOException {
        if (this.input == null) {
            ServletInputStream delegateTo = super.getInputStream();
            this.input = new MonitorInputStream(delegateTo, this.maxSize);
        }
        return this.input;
    }

    public BufferedReader getReader() throws IOException {
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader((InputStream)((Object)this.getInputStream())));
        }
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.getInputStream()), encoding));
    }

    static class MonitorInputStream
    extends ServletInputStream {
        ByteArrayOutputStream buffer;
        ServletInputStream delegate;
        long nbytes = 0L;
        long maxSize;

        public MonitorInputStream(ServletInputStream delegate, long maxSize) {
            this.delegate = delegate;
            this.maxSize = maxSize;
            if (maxSize > 0L || maxSize == -1L) {
                this.buffer = new ByteArrayOutputStream();
            }
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public long skip(long n) throws IOException {
            this.nbytes += n;
            return this.delegate.skip(n);
        }

        public int read() throws IOException {
            int b = this.delegate.read();
            if (!this.bufferIsFull()) {
                this.buffer.write((byte)b);
            }
            if (b >= 0) {
                ++this.nbytes;
            }
            return b;
        }

        public int read(byte[] b) throws IOException {
            int n = this.delegate.read(b);
            this.fill(b, 0, n);
            this.nbytes += (long)n;
            return n;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.delegate.read(b, off, len);
            this.fill(b, off, n);
            this.nbytes += (long)n;
            return n;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int n = this.delegate.readLine(b, off, len);
            this.fill(b, off, n);
            this.nbytes += (long)n;
            return n;
        }

        public boolean isFinished() {
            return this.delegate.isFinished();
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.delegate.setReadListener(readListener);
        }

        void fill(byte[] b, int off, int len) {
            if (len < 0) {
                return;
            }
            if (!this.bufferIsFull()) {
                if (this.maxSize > 0L) {
                    long residual = this.maxSize - (long)this.buffer.size();
                    len = (long)len < residual ? len : (int)residual;
                }
                this.buffer.write(b, off, len);
            }
        }

        boolean bufferIsFull() {
            return this.maxSize == 0L || (long)this.buffer.size() >= this.maxSize && this.maxSize > 0L && this.maxSize != -1L;
        }

        public byte[] getData() {
            return this.buffer == null ? new byte[]{} : this.buffer.toByteArray();
        }

        public long getBytesRead() {
            return this.nbytes;
        }

        public void dispose() {
            this.buffer = null;
            this.delegate = null;
        }
    }
}

