/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.monitor.MonitorFilter;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.IOUtils;
import org.springframework.util.AntPathMatcher;

public class MonitorRequestFilter {
    FileWatcher<List<Filter>> watcher;
    List<Filter> filters;

    public MonitorRequestFilter() {
        this.filters = new ArrayList<Filter>();
    }

    public MonitorRequestFilter(GeoServerResourceLoader loader) throws IOException {
        Resource configFile = loader.get(Paths.path((String[])new String[]{"monitoring", "filter.properties"}));
        if (configFile.getType() == Resource.Type.UNDEFINED) {
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("filter.properties"), (OutputStream)configFile.out());
        }
        this.filters = new ArrayList<Filter>();
        this.watcher = new FilterPropertyFileWatcher(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filter(HttpServletRequest req) throws IOException {
        if (this.watcher != null && this.watcher.isModified()) {
            MonitorRequestFilter monitorRequestFilter = this;
            synchronized (monitorRequestFilter) {
                if (this.watcher.isModified()) {
                    this.filters = (List)this.watcher.read();
                }
            }
        }
        String path = req.getServletPath() + req.getPathInfo();
        if (MonitorFilter.LOGGER.isLoggable(Level.FINER)) {
            MonitorFilter.LOGGER.finer("Testing " + path + " for monitor filtering");
        }
        if (this.filters != null) {
            for (Filter f : this.filters) {
                if (!f.matches(path)) continue;
                return true;
            }
        }
        return false;
    }

    static class Filter {
        AntPathMatcher matcher = new AntPathMatcher();
        String pattern;

        Filter(String pattern) {
            this.pattern = pattern;
        }

        boolean matches(String path) {
            return this.matcher.match(this.pattern, path);
        }
    }

    private final class FilterPropertyFileWatcher
    extends FileWatcher<List<Filter>> {
        private FilterPropertyFileWatcher(Resource resource) {
            super(resource);
        }

        protected List<Filter> parseFileContents(InputStream in) throws IOException {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = r.readLine()) != null) {
                filters.add(new Filter(line));
            }
            return filters;
        }
    }
}

