/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.geoserver.monitor.Filter;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.MonitorVisitor;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.monitor.ResourceData;
import org.geoserver.ows.util.OwsUtils;

public class MemoryMonitorDAO
implements MonitorDAO {
    public static final String NAME = "memory";
    Queue<RequestData> live = new ConcurrentLinkedQueue<RequestData>();
    Queue<RequestData> history = new ConcurrentLinkedQueue<RequestData>();
    AtomicLong REQUEST_ID_GEN = new AtomicLong(1L);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(MonitorConfig config) {
    }

    @Override
    public RequestData init(RequestData data) {
        data.setId(this.REQUEST_ID_GEN.getAndIncrement());
        return data;
    }

    @Override
    public void add(RequestData data) {
        this.live.add(data);
    }

    @Override
    public void update(RequestData data) {
    }

    @Override
    public void save(RequestData data) {
        this.live.remove(data);
        this.history.add(data);
        if (this.history.size() > 100) {
            this.history.poll();
        }
    }

    @Override
    public RequestData getRequest(long id) {
        for (RequestData r : this.getRequests()) {
            if (r.getId() != id) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<RequestData> getRequests() {
        LinkedList<RequestData> requests = new LinkedList<RequestData>();
        requests.addAll(this.live);
        requests.addAll(this.history);
        return requests;
    }

    @Override
    public List<RequestData> getRequests(Query q) {
        List<RequestData> requests = this.getRequests();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (q.getFilter() != null) {
            Filter f = q.getFilter();
            predicates.add(new PropertyCompare(f.getLeft(), f.getType(), f.getRight()));
        }
        if (q.getFromDate() != null || q.getToDate() != null) {
            predicates.add(new DateRange(q.getFromDate(), q.getToDate()));
        }
        int i = 1;
        int count = 0;
        Iterator<RequestData> it = requests.iterator();
        block0: while (it.hasNext()) {
            RequestData r = it.next();
            for (Predicate p : predicates) {
                if (p.matches(r)) continue;
                it.remove();
                continue block0;
            }
            if (q.getOffset() != null && q.getOffset() >= (long)i++) {
                it.remove();
                continue;
            }
            if (q.getCount() != null && q.getCount() <= (long)count) {
                it.remove();
                continue;
            }
            ++count;
        }
        if (q.getSortBy() != null) {
            Collections.sort(requests, new Sorter(q.getSortBy(), q.getSortOrder()));
        } else if (q.getFromDate() != null || q.getToDate() != null) {
            Collections.sort(requests, new Sorter("startTime", Query.SortOrder.DESC));
        }
        return requests;
    }

    @Override
    public void getRequests(Query query, RequestDataVisitor visitor) {
        for (RequestData r : this.getRequests(query)) {
            visitor.visit(r, new Object[0]);
        }
    }

    @Override
    public long getCount(Query query) {
        return this.getRequests(query).size();
    }

    @Override
    public Iterator<RequestData> getIterator(Query query) {
        return this.getRequests(query).iterator();
    }

    public ResourceData getLayer(String name) {
        return null;
    }

    public List<ResourceData> getLayers() {
        return null;
    }

    public List<ResourceData> getLayers(Query query) {
        return null;
    }

    public void getLayers(Query query, MonitorVisitor<ResourceData> visitor) {
    }

    @Override
    public List<RequestData> getOwsRequests() {
        return null;
    }

    @Override
    public List<RequestData> getOwsRequests(String service, String operation, String version) {
        return null;
    }

    @Override
    public void clear() {
        this.live.clear();
        this.history.clear();
    }

    @Override
    public void dispose() {
        this.live.clear();
        this.history.clear();
        this.REQUEST_ID_GEN = new AtomicLong(1L);
    }

    static class Sorter
    implements Comparator<RequestData> {
        String property;
        Query.SortOrder order;

        Sorter(String property, Query.SortOrder order) {
            this.property = property;
            this.order = order;
        }

        @Override
        public int compare(RequestData r1, RequestData r2) {
            int c = this.compareInternal(r1, r2);
            return this.order == Query.SortOrder.ASC ? c : -1 * c;
        }

        public int compareInternal(RequestData r1, RequestData r2) {
            Object o1 = OwsUtils.get((Object)r1, (String)this.property);
            Object o2 = OwsUtils.get((Object)r2, (String)this.property);
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    static class PropertyCompare
    implements Predicate {
        Object left;
        Object right;
        Query.Comparison compare;

        public PropertyCompare(Object left, Query.Comparison compare, Object right) {
            this.left = left;
            this.right = right;
            this.compare = compare;
        }

        @Override
        public boolean matches(RequestData data) {
            String property = null;
            Object value = null;
            if (this.left instanceof String && OwsUtils.has((Object)data, (String)((String)this.left))) {
                property = (String)this.left;
                value = this.right;
            } else if (this.right instanceof String && OwsUtils.has((Object)data, (String)((String)this.right))) {
                property = (String)this.right;
                value = this.left;
            }
            if (property == null) {
                throw new IllegalArgumentException("Could not find property");
            }
            Object o = OwsUtils.get((Object)data, property);
            if (o == null) {
                return value == null && this.compare == Query.Comparison.EQ;
            }
            if (this.compare == Query.Comparison.IN) {
                if (!(value instanceof List)) {
                    throw new UnsupportedOperationException("IN comparison only supported against list values");
                }
                return ((List)value).contains(o);
            }
            if (this.compare == Query.Comparison.EQ) {
                return o.equals(value);
            }
            if (this.compare == Query.Comparison.NEQ) {
                return !o.equals(value);
            }
            if (o instanceof Comparable) {
                return this.compare(value, (Comparable)o);
            }
            throw new UnsupportedOperationException("Values of type " + value.getClass().getName() + " only support equality and non-equality comparison.");
        }

        private boolean compare(Object value, Comparable o) {
            int c = o.compareTo(value);
            switch (this.compare) {
                case LT: {
                    return c < 0;
                }
                case LTE: {
                    return c <= 0;
                }
                case GT: {
                    return c > 0;
                }
                case GTE: {
                    return c >= 0;
                }
            }
            return false;
        }
    }

    static class DateRange
    implements Predicate {
        Date from;
        Date to;

        DateRange(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean matches(RequestData data) {
            Date time = data.getStartTime();
            if (time == null) {
                return false;
            }
            if (this.from != null && time.before(this.from)) {
                return false;
            }
            return this.to == null || !time.after(this.to);
        }
    }

    static interface Predicate {
        public boolean matches(RequestData var1);
    }
}

