/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestPostProcessor;

public class LayerNameNormalizer
implements RequestPostProcessor {
    static final String PROCESSOR_NAME = "layerNameNormalizer";
    Catalog cat;

    public LayerNameNormalizer(Catalog cat) {
        this.cat = cat;
    }

    @Override
    public void run(RequestData data, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<String> layers = data.getResources();
        if (layers == null) {
            return;
        }
        int size = layers.size();
        for (int i = 0; i < size; ++i) {
            String layer = layers.get(i);
            int colon = layer.lastIndexOf(58);
            if (colon == -1) {
                LayerInfo l = this.cat.getLayerByName(layer);
                if (l == null) continue;
                layers.set(i, l.getResource().prefixedName());
                continue;
            }
            String prefix = layer.substring(0, colon);
            String local = layer.substring(colon + 1);
            NamespaceInfo ns = this.cat.getNamespaceByPrefix(prefix);
            if (ns != null) continue;
            ns = this.cat.getNamespaceByURI(prefix);
            if (ns != null) {
                prefix = ns.getPrefix();
            }
            layers.set(i, prefix + ":" + local);
        }
    }

    @Override
    public String getName() {
        return PROCESSOR_NAME;
    }
}

