/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.geoserver.monitor.MemoryMonitorDAO;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.MonitorTestData;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.ows.ControlFlowCallbackProxy;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ControlFlowCallbackProxyTest {
    static Monitor monitor;

    @BeforeClass
    public static void setUpData() throws Exception {
        MemoryMonitorDAO dao = new MemoryMonitorDAO();
        new MonitorTestData((MonitorDAO)dao).setup();
        monitor = new Monitor((MonitorDAO)dao);
    }

    @Test
    public void test() throws Exception {
        final RequestData data = monitor.start();
        DispatcherCallback callback = new DispatcherCallback(){

            public Service serviceDispatched(Request request, Service service) throws ServiceException {
                return null;
            }

            public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
                return null;
            }

            public Object operationExecuted(Request request, Operation operation, Object result) {
                return null;
            }

            public Operation operationDispatched(Request request, Operation operation) {
                Assert.assertEquals((Object)RequestData.Status.WAITING, (Object)data.getStatus());
                return operation;
            }

            public Request init(Request request) {
                return null;
            }

            public void finished(Request request) {
            }
        };
        callback = this.createProxy(callback);
        callback.operationDispatched(new Request(), new Operation("foo", new Service("bar", null, null, null), null, null));
        Assert.assertEquals((Object)RequestData.Status.RUNNING, (Object)data.getStatus());
    }

    @Test
    public void testGetRunningAndBlockedRequests() throws Exception {
        MyDispatcherCallback callback = new MyDispatcherCallback();
        callback = this.createProxy(callback);
        ControlFlowCallbackProxy proxy = (ControlFlowCallbackProxy)Proxy.getInvocationHandler(callback);
        Assert.assertNotNull((Object)proxy);
        Assert.assertEquals((long)10L, (long)proxy.getRunningRequests());
        Assert.assertEquals((long)2L, (long)proxy.getBlockedRequests());
    }

    DispatcherCallback createProxy(DispatcherCallback callback) {
        ControlFlowCallbackProxy proxy = new ControlFlowCallbackProxy(monitor, (Object)callback);
        return (DispatcherCallback)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DispatcherCallback.class}, (InvocationHandler)proxy);
    }

    public static class MyDispatcherCallback
    implements DispatcherCallback {
        public long getRunningRequests() {
            return 10L;
        }

        public long getBlockedRequests() {
            return 2L;
        }

        public Service serviceDispatched(Request request, Service service) throws ServiceException {
            return null;
        }

        public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
            return null;
        }

        public Object operationExecuted(Request request, Operation operation, Object result) {
            return null;
        }

        public Operation operationDispatched(Request request, Operation operation) {
            return null;
        }

        public Request init(Request request) {
            return null;
        }

        public void finished(Request request) {
        }
    }
}

