/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.RequestData;
import org.geotools.util.Converters;
import org.junit.Assert;

public class MonitorTestData {
    static DateFormat FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    MonitorDAO dao;
    List<RequestData> data;
    boolean extended;

    public MonitorTestData(MonitorDAO dao) {
        this(dao, true);
    }

    public MonitorTestData(MonitorDAO dao, boolean extended) {
        this.dao = dao;
        this.data = new ArrayList<RequestData>();
        this.extended = extended;
    }

    public List<RequestData> getData() {
        return this.data;
    }

    public void setup() throws ParseException {
        this.data.add(this.data(1L, "/one", "2010-07-23T15:26:44", "2010-07-23T15:26:59", "RUNNING"));
        this.data.add(this.data(2L, "/two", "2010-07-23T15:36:44", "2010-07-23T15:36:47", "WAITING"));
        this.data.add(this.data(3L, "/three", "2010-07-23T15:46:44", "2010-07-23T15:46:52", "FINISHED"));
        this.data.add(this.data(4L, "/four", "2010-07-23T15:56:44", "2010-07-23T15:56:48", "FAILED"));
        this.data.add(this.data(5L, "/five", "2010-07-23T16:06:44", "2010-07-23T16:06:45", "RUNNING"));
        this.data.add(this.data(6L, "/six", "2010-07-23T16:16:44", "2010-07-23T16:16:53", "WAITING"));
        this.data.add(this.data(7L, "/seven", "2010-07-23T16:26:44", "2010-07-23T16:26:47", "FINISHED"));
        this.data.add(this.data(8L, "/eight", "2010-07-23T16:36:44", "2010-07-23T16:36:46", "FAILED"));
        this.data.add(this.data(9L, "/nine", "2010-07-23T16:46:44", "2010-07-23T16:46:53", "CANCELLING"));
        this.data.add(this.data(10L, "/ten", "2010-07-23T16:56:44", "2010-07-23T16:56:47", "RUNNING"));
        if (this.extended) {
            this.data.add(this.data(11L, "/foo", "2010-08-23T15:26:44", "2010-08-23T15:26:59", "RUNNING", "foo", "x", "widgets"));
            this.data.add(this.data(12L, "/bar", "2010-08-23T15:36:44", "2010-08-23T15:36:47", "WAITING", "bar", "y", "things"));
            this.data.add(this.data(13L, "/baz", "2010-08-23T15:46:44", "2010-08-23T15:46:52", "FINISHED", "baz", "x", "stuff"));
            this.data.add(this.data(14L, "/bam", "2010-08-23T15:56:44", "2010-08-23T15:56:48", "FAILED", "bam", "x", "widgets", "things"));
            this.data.add(this.data(15L, "/foo", "2010-08-23T16:06:44", "2010-08-23T16:06:45", "RUNNING", "foo", "x", "things", "stuff"));
            this.data.add(this.data(16L, "/foo", "2010-08-23T16:16:44", "2010-08-23T16:16:53", "WAITING", "foo", "x", "stuff"));
            this.data.add(this.data(17L, "/bar", "2010-08-23T16:26:44", "2010-08-23T16:26:47", "FINISHED", "bar", "z", "things", "stuff"));
            this.data.add(this.data(18L, "/bam", "2010-08-23T16:36:44", "2010-08-23T16:36:46", "FAILED", "bam", "y", "widgets"));
            this.data.add(this.data(19L, "/bam", "2010-08-23T16:46:44", "2010-08-23T16:46:53", "CANCELLING", "bam", "y", "stuff"));
            this.data.add(this.data(20L, "/foo", "2010-08-23T16:56:44", "2010-08-23T16:56:47", "RUNNING", "foo", "x", "things"));
        }
        this.addTestData(this.data);
        for (RequestData r : this.data) {
            this.dao.save(this.dao.init(r));
        }
    }

    protected RequestData data(long id, String path, String start, String end, String status) throws ParseException {
        RequestData data = new RequestData();
        data.setPath(path);
        data.setStartTime(MonitorTestData.toDate(start));
        data.setEndTime(MonitorTestData.toDate(end));
        data.setStatus(RequestData.Status.valueOf((String)status));
        return data;
    }

    protected RequestData data(long id, String path, String start, String end, String status, String owsService, String owsOperation, String ... layers) throws ParseException {
        RequestData data = this.data(id, path, start, end, status);
        data.setService(owsService);
        data.setOperation(owsOperation);
        data.setResources(Arrays.asList(layers));
        return data;
    }

    protected void addTestData(List<RequestData> datas) throws ParseException {
    }

    public static Date toDate(String s) {
        return (Date)Converters.convert((Object)s, Date.class);
    }

    public static void assertCovered(List<RequestData> datas, int ... id) {
        Assert.assertEquals((long)id.length, (long)datas.size());
        HashSet<Long> ids = new HashSet<Long>();
        for (RequestData data : datas) {
            ids.add(data.getId());
        }
        for (Object j : (Object)id) {
            Assert.assertTrue((boolean)ids.contains((long)j));
        }
    }

    public static void assertCoveredInOrder(List<RequestData> datas, int ... id) {
        Assert.assertEquals((long)id.length, (long)datas.size());
        for (int i = 0; i < id.length; ++i) {
            Assert.assertEquals((long)id[i], (long)datas.get(i).getId());
        }
    }
}

