/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.easymock.EasyMock;
import org.geoserver.monitor.DummyMonitorDAO;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.MonitorFilter;
import org.geoserver.monitor.MonitorRequestFilter;
import org.geoserver.monitor.RequestData;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public class MonitorFilterTest {
    DummyMonitorDAO dao;
    MonitorFilter filter;
    MockFilterChain chain;
    static final int MAX_BODY_SIZE = 10;
    static final int LONG_BODY_SIZE = 30;

    @Before
    public void setUp() throws Exception {
        this.dao = new DummyMonitorDAO();
        this.filter = new MonitorFilter(new Monitor((MonitorDAO)this.dao), new MonitorRequestFilter());
        this.chain = new MockFilterChain((Servlet)new HttpServlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                req.getInputStream().read(new byte[30]);
                res.getOutputStream().write(new byte[0]);
            }
        });
        this.filter.monitor.config.props.put("maxBodySize", Integer.toString(10));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSimple() throws Exception {
        MockHttpServletRequest req = this.request("GET", "/foo/bar", "12.34.56.78", null, null);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)"GET", (Object)data.getHttpMethod());
        Assert.assertEquals((Object)"/foo/bar", (Object)data.getPath());
        Assert.assertEquals((Object)"12.34.56.78", (Object)data.getRemoteAddr());
        Assert.assertNull((Object)data.getHttpReferer());
    }

    @Test
    public void testWithBody() throws Exception {
        this.chain = new MockFilterChain((Servlet)new HttpServlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                req.getInputStream().read(new byte[30]);
                res.getOutputStream().write("hello".getBytes());
            }
        });
        MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", "baz", null);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)"POST", (Object)data.getHttpMethod());
        Assert.assertEquals((Object)"/bar/foo", (Object)data.getPath());
        Assert.assertEquals((Object)"78.56.34.12", (Object)data.getRemoteAddr());
        Assert.assertNull((Object)data.getHttpReferer());
        Assert.assertEquals((Object)new String(data.getBody()), (Object)"baz");
        Assert.assertEquals((long)3L, (long)data.getBodyContentLength());
        Assert.assertEquals((long)5L, (long)data.getResponseLength());
    }

    @Test
    public void testWithLongBody() throws Exception {
        this.chain = new MockFilterChain((Servlet)new HttpServlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                req.getInputStream().read(new byte[30]);
                res.getOutputStream().write("hello".getBytes());
            }
        });
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            b.append('b');
        }
        String wanted_body = b.toString();
        for (int i = 10; i < 30; ++i) {
            b.append('b');
        }
        String given_body = b.toString();
        MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", given_body, null);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)wanted_body, (Object)new String(data.getBody()));
        Assert.assertEquals((long)30L, (long)data.getBodyContentLength());
    }

    @Test
    public void testWithUnboundedBody() throws Exception {
        int UNBOUNDED_BODY_SIZE = 10000;
        this.filter.monitor.config.props.put("maxBodySize", Integer.toString(10000));
        this.chain = new MockFilterChain((Servlet)new HttpServlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                while (req.getInputStream().read() != -1) {
                }
                req.getInputStream().read();
                res.getOutputStream().write("hello".getBytes());
            }
        });
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            b.append(i % 10);
        }
        String wanted_body = b.toString();
        String given_body = b.toString();
        MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", given_body, null);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)wanted_body, (Object)new String(data.getBody()));
        Assert.assertEquals((long)10000L, (long)data.getBodyContentLength());
    }

    @Test
    public void testReferer() throws Exception {
        MockHttpServletRequest req = this.request("GET", "/foo/bar", "12.34.56.78", null, "http://testhost/testpath");
        this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)"GET", (Object)data.getHttpMethod());
        Assert.assertEquals((Object)"/foo/bar", (Object)data.getPath());
        Assert.assertEquals((Object)"12.34.56.78", (Object)data.getRemoteAddr());
        Assert.assertEquals((Object)"http://testhost/testpath", (Object)data.getHttpReferer());
    }

    @Test
    public void testReferrer() throws Exception {
        MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", null, null);
        req.addHeader("Referrer", (Object)"http://testhost/testpath");
        this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)"POST", (Object)data.getHttpMethod());
        Assert.assertEquals((Object)"/bar/foo", (Object)data.getPath());
        Assert.assertEquals((Object)"78.56.34.12", (Object)data.getRemoteAddr());
        Assert.assertEquals((Object)"http://testhost/testpath", (Object)data.getHttpReferer());
        Assert.assertNull((Object)data.getCacheResult());
        Assert.assertNull((Object)data.getMissReason());
    }

    @Test
    public void testGWCHeaders() throws Exception {
        MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", null, null);
        MockHttpServletResponse response = this.response();
        String cacheResult = "Miss";
        response.addHeader("geowebcache-cache-result", cacheResult);
        String missReason = "Wrong planet alignment";
        response.addHeader("geowebcache-miss-reason", missReason);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)response, (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        Assert.assertEquals((Object)"POST", (Object)data.getHttpMethod());
        Assert.assertEquals((Object)"/bar/foo", (Object)data.getPath());
        Assert.assertEquals((Object)"78.56.34.12", (Object)data.getRemoteAddr());
        Assert.assertEquals((Object)cacheResult, (Object)data.getCacheResult());
        Assert.assertEquals((Object)missReason, (Object)data.getMissReason());
    }

    @Test
    public void testUserRemoteUser() throws Exception {
        User principal = new User("username", "", Collections.emptyList());
        this.testRemoteUser(principal);
    }

    @Test
    public void testUserDetailsRemoteUser() throws Exception {
        UserDetails principal = (UserDetails)EasyMock.createMock(UserDetails.class);
        EasyMock.expect((Object)principal.getUsername()).andReturn((Object)"username");
        EasyMock.replay((Object[])new Object[]{principal});
        this.testRemoteUser(principal);
    }

    @Test
    public void testGetStatistics() throws IOException, ServletException {
        MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", null, null);
        MockHttpServletResponse response = this.response();
        RenderTimeStatistics statistics = (RenderTimeStatistics)req.getAttribute("statistics");
        this.filter.doFilter((ServletRequest)req, (ServletResponse)response, (FilterChain)this.chain);
        RequestData data = this.dao.getLast();
        String layerNamesList = statistics.getLayerNames().toString();
        Assert.assertEquals((Object)data.getResourcesList(), (Object)layerNamesList.substring(1, layerNamesList.length() - 1));
        Assert.assertNotEquals((long)data.getResourcesProcessingTimeList().indexOf(statistics.getRenderingTime(Integer.valueOf(0)).toString()), (long)-1L);
        Assert.assertEquals((long)data.getLabellingProcessingTime(), (long)statistics.getLabellingTime());
    }

    @Test
    public void testDisableReverseDNSProcessor() throws Exception {
        User principal = new User("username", "", Collections.emptyList());
        RequestData data = this.testRemoteUser(principal);
        Assert.assertNotNull((Object)data.getRemoteHost());
        try {
            this.filter = new MonitorFilter(new Monitor((MonitorDAO)this.dao), new MonitorRequestFilter());
            this.filter.monitor.config.props.put("ignorePostProcessors", "reverseDNS");
            this.chain = new MockFilterChain((Servlet)new HttpServlet(){

                public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                    req.getInputStream().read(new byte[30]);
                    res.getOutputStream().write(new byte[0]);
                }
            });
            principal = new User("username", "", Collections.emptyList());
            data = this.testRemoteUser(principal);
            Assert.assertNull((Object)data.getRemoteHost());
        }
        finally {
            this.filter.monitor.config.props.remove("ignorePostProcessors");
        }
    }

    RenderTimeStatistics createStatistcis() {
        RenderTimeStatistics stats = (RenderTimeStatistics)EasyMock.createMock(RenderTimeStatistics.class);
        EasyMock.expect((Object)stats.getRenderingLayersIdxs()).andReturn(Arrays.asList(0)).anyTimes();
        EasyMock.expect((Object)stats.getRenderingTime(Integer.valueOf(0))).andReturn((Object)100L).anyTimes();
        EasyMock.expect((Object)stats.getLabellingTime()).andReturn((Object)100L).anyTimes();
        EasyMock.expect((Object)stats.getLayerNames()).andReturn(Arrays.asList("Layer1")).anyTimes();
        EasyMock.replay((Object[])new Object[]{stats});
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestData testRemoteUser(Object principal) throws Exception {
        try {
            TestingAuthenticationToken authentication = new TestingAuthenticationToken(principal, null);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            CompletableFuture authFuture = new CompletableFuture();
            this.filter.setExecutionAudit((data, auth) -> authFuture.complete(auth));
            MockHttpServletRequest req = this.request("POST", "/bar/foo", "78.56.34.12", null, null);
            this.filter.doFilter((ServletRequest)req, (ServletResponse)this.response(), (FilterChain)this.chain);
            RequestData data2 = this.dao.getLast();
            Assert.assertEquals((Object)"username", (Object)data2.getRemoteUser());
            Assert.assertEquals((Object)authentication, authFuture.get());
            RequestData requestData = data2;
            return requestData;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
            this.filter.setExecutionAudit(null);
        }
    }

    MockHttpServletRequest request(String method, String path, String remoteAddr, String body, String referer) throws UnsupportedEncodingException {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setMethod(method);
        req.setServerName("localhost");
        req.setServletPath(path.substring(0, path.indexOf(47, 1)));
        req.setPathInfo(path.substring(path.indexOf(47, 1)));
        req.setRemoteAddr(remoteAddr);
        if (body == null) {
            body = "";
        }
        req.setContent(body.getBytes(StandardCharsets.UTF_8));
        req.setAttribute("statistics", (Object)this.createStatistcis());
        if (referer != null) {
            req.addHeader("Referer", (Object)referer);
        }
        return req;
    }

    MockHttpServletResponse response() {
        MockHttpServletResponse response = new MockHttpServletResponse();
        return response;
    }
}

