/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.awaitility.Awaitility;
import org.geoserver.monitor.PipeliningTaskQueue;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeliningTaskQueueTest {
    static final Logger LOGGER = Logging.getLogger(PipeliningTaskQueueTest.class);
    PipeliningTaskQueue<Integer> taskQueue;

    @Before
    public void setUp() throws Exception {
        this.taskQueue = new PipeliningTaskQueue();
        this.taskQueue.start();
    }

    @After
    public void tearDown() throws Exception {
        this.taskQueue.stop();
    }

    @Test
    public void test() throws Exception {
        int i;
        ConcurrentLinkedQueue<Worker> completed = new ConcurrentLinkedQueue<Worker>();
        int groups = 5;
        ArrayList workers = new ArrayList();
        for (i = 0; i < groups; ++i) {
            ArrayList<Worker> list = new ArrayList<Worker>();
            for (int j = 0; j < groups; ++j) {
                list.add(new Worker(i, j, completed));
            }
            workers.add(list);
        }
        for (i = 0; i < groups; ++i) {
            for (int j = 0; j < groups; ++j) {
                Worker w = (Worker)((List)workers.get(j)).get(i);
                this.taskQueue.execute((Object)w.group, (Runnable)w);
            }
        }
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> completed.size() >= groups * groups);
        int[] status = new int[groups];
        for (Worker w : completed) {
            Assert.assertEquals((long)status[w.group], (long)w.seq.intValue());
            int n = w.group;
            status[n] = status[n] + 1;
        }
    }

    static class Worker
    implements Runnable {
        Integer group;
        Integer seq;
        Queue<Worker> completed;

        public Worker(Integer group, Integer seq, Queue<Worker> completed) {
            this.group = group;
            this.seq = seq;
            this.completed = completed;
        }

        @Override
        public void run() {
            Random r = new Random();
            int x = r.nextInt(10) + 1;
            try {
                Thread.sleep(x * 10);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "", e);
            }
            this.completed.add(this);
        }
    }
}

