/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.MonitorTestData;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.junit.Assert;
import org.junit.Test;

public abstract class MonitorDAOTestSupport {
    protected static MonitorTestData testData;
    protected static MonitorDAO dao;

    protected static void setUpData() throws Exception {
        testData = new MonitorTestData(dao);
        testData.setup();
    }

    @Test
    public void testUpdate() throws Exception {
        RequestData data = dao.getRequest(1L);
        data.setPath("/one_updated");
        dao.update(data);
        data = dao.getRequest(1L);
        Assert.assertEquals((Object)"/one_updated", (Object)data.getPath());
        data.getResources().add("one_layer");
        dao.update(data);
        data = dao.getRequest(1L);
        Assert.assertEquals((long)1L, (long)data.getResources().size());
        Assert.assertEquals((Object)"one_layer", data.getResources().get(0));
    }

    @Test
    public void testGetRequests() throws Exception {
        List requests = dao.getRequests();
        Assert.assertEquals((long)testData.getData().size(), (long)requests.size());
        MonitorTestData.assertCovered(requests, this.range(1, 20));
    }

    int[] range(int low, int high) {
        int[] nums = new int[high - low + 1];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = low + i;
        }
        return nums;
    }

    @Test
    public void testGetRequestsVisitor() throws Exception {
        ArrayList<RequestData> datas = new ArrayList<RequestData>();
        dao.getRequests(new Query().filter((Object)"path", (Object)"/seven", Query.Comparison.EQ), (data, aggregates) -> datas.add((RequestData)data));
        MonitorTestData.assertCoveredInOrder(datas, 7);
    }

    @Test
    public void testGetRequestById() throws Exception {
        Assert.assertNotNull((Object)dao.getRequest(8L));
        Assert.assertEquals((Object)"/eight", (Object)dao.getRequest(8L).getPath());
    }

    @Test
    public void testGetRequestsSorted() throws Exception {
        MonitorTestData.assertCoveredInOrder(dao.getRequests(new Query().filter((Object)"id", (Object)11L, Query.Comparison.LT).sort("path", Query.SortOrder.ASC)), 8, 5, 4, 9, 1, 7, 6, 10, 3, 2);
    }

    @Test
    public void testGetRequestsBetween() throws Exception {
        List datas = dao.getRequests(new Query().between(MonitorTestData.toDate("2010-07-23T15:55:00"), MonitorTestData.toDate("2010-07-23T16:17:00")));
        MonitorTestData.assertCoveredInOrder(datas, 6, 5, 4);
    }

    @Test
    public void testGetRequestsBetween2() throws Exception {
        List datas = dao.getRequests(new Query().between(MonitorTestData.toDate("2010-07-23T15:56:44"), MonitorTestData.toDate("2010-07-23T16:16:44")).sort("startTime", Query.SortOrder.ASC));
        MonitorTestData.assertCoveredInOrder(datas, 4, 5, 6);
    }

    @Test
    public void testGetRequestsPaged() throws Exception {
        List datas = dao.getRequests(new Query().page(Long.valueOf(5L), Long.valueOf(2L)).sort("startTime", Query.SortOrder.ASC));
        MonitorTestData.assertCoveredInOrder(datas, 6, 7);
    }

    @Test
    public void testGetRequestsFilter() throws Exception {
        MonitorTestData.assertCoveredInOrder(dao.getRequests(new Query().filter((Object)"path", (Object)"/seven", Query.Comparison.EQ)), 7);
    }

    @Test
    public void testGetRequestsFilterNull() throws Exception {
        Assert.assertEquals((long)0L, (long)dao.getRequests(new Query().filter((Object)"path", null, Query.Comparison.EQ)).size());
        Assert.assertEquals((long)testData.getData().size(), (long)dao.getRequests(new Query().filter((Object)"path", null, Query.Comparison.NEQ)).size());
    }

    @Test
    public void testGetRequestsFilterIN() throws Exception {
        List datas = dao.getRequests(new Query().filter((Object)"path", Arrays.asList("/two", "/seven"), Query.Comparison.IN));
        MonitorTestData.assertCovered(datas, 2, 7);
    }

    @Test
    public void testGetRequestsFilterIN2() throws Exception {
        List datas = dao.getRequests(new Query().filter((Object)"status", Arrays.asList(RequestData.Status.RUNNING, RequestData.Status.WAITING), Query.Comparison.IN));
        MonitorTestData.assertCovered(datas, 1, 2, 5, 6, 10, 11, 12, 15, 16, 20);
    }

    @Test
    public void testGetCount() throws Exception {
        Assert.assertEquals((long)4L, (long)dao.getCount(new Query().filter((Object)"path", (Object)"/foo", Query.Comparison.EQ)));
    }

    @Test
    public void testGetIterator() throws Exception {
        Iterator it = dao.getIterator(new Query().filter((Object)"path", Arrays.asList("/two", "/seven"), Query.Comparison.IN));
        Assert.assertTrue((boolean)it.hasNext());
        RequestData data = (RequestData)it.next();
        Assert.assertEquals((Object)"/two", (Object)data.getPath());
        Assert.assertTrue((boolean)it.hasNext());
        data = (RequestData)it.next();
        Assert.assertEquals((Object)"/seven", (Object)data.getPath());
        Assert.assertFalse((boolean)it.hasNext());
    }
}

